/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;

public class RecursiveParamInitializer
extends DefaultParamInitializer {
    public static final String W = "w";
    public static final String U = "u";
    public static final String BIAS = "b";
    public static final String C = "c";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        Distribution dist = Distributions.createDistribution(conf.getDist());
        int vis = conf.getnIn();
        int out = vis * 2;
        params.put(W, WeightInitUtil.initWeights(new int[]{out, vis}, conf.getWeightInit(), dist));
        params.put(U, WeightInitUtil.initWeights(new int[]{vis, out}, conf.getWeightInit(), dist));
        params.put(BIAS, WeightInitUtil.initWeights(new int[]{out}, conf.getWeightInit(), dist));
        params.put(C, WeightInitUtil.initWeights(new int[]{vis}, conf.getWeightInit(), dist));
        conf.addVariable(W);
        conf.addVariable(U);
        conf.addVariable(BIAS);
        conf.addVariable(C);
    }
}

