/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.preprocessor;

import org.deeplearning4j.nn.conf.OutputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.util.ArrayUtil;

public class ConvolutionPostProcessor
implements OutputPreProcessor {
    private int[] shape;

    public ConvolutionPostProcessor(int[] shape) {
        this.shape = shape;
    }

    public ConvolutionPostProcessor() {
    }

    @Override
    public INDArray preProcess(INDArray output) {
        if (this.shape == null || ArrayUtil.prod((int[])this.shape) != output.length()) {
            if (output.shape().length == 4) {
                int[] otherOutputs = new int[3];
                int[] outputShape = output.shape();
                System.arraycopy(outputShape, 1, otherOutputs, 0, otherOutputs.length);
                this.shape = new int[]{output.shape()[0], ArrayUtil.prod((int[])otherOutputs)};
            } else if (output.shape().length == 3) {
                int[] otherOutputs = new int[2];
                int[] outputShape = output.shape();
                System.arraycopy(outputShape, 1, otherOutputs, 0, otherOutputs.length);
                this.shape = new int[]{output.shape()[0], ArrayUtil.prod((int[])otherOutputs)};
            }
        }
        return output.reshape(this.shape);
    }
}

