/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.mnist.draw;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.datasets.iterator.impl.MnistDataSetIterator;
import org.deeplearning4j.datasets.mnist.draw.DrawReconstruction;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.sampling.Sampling;

public class LoadAndDraw {
    public static void main(String[] args) throws Exception {
        MnistDataSetIterator iter = new MnistDataSetIterator(60, 60000);
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(args[0]));
        BasePretrainNetwork network = (BasePretrainNetwork)ois.readObject();
        Object test = null;
        while (iter.hasNext()) {
            INDArray reconstructed = network.transform(test.getFeatureMatrix());
            for (int i = 0; i < test.numExamples(); ++i) {
                INDArray draw1 = test.get(i).getFeatureMatrix().mul((Number)255);
                INDArray reconstructed2 = reconstructed.getRow(i);
                INDArray draw2 = Sampling.binomial((INDArray)reconstructed2, (int)1, (RandomGenerator)new MersenneTwister(123)).mul((Number)255);
                DrawReconstruction d = new DrawReconstruction(draw1);
                d.title = "REAL";
                d.draw();
                DrawReconstruction d2 = new DrawReconstruction(draw2, 100, 100);
                d2.title = "TEST";
                d2.draw();
                Thread.sleep(10000L);
                d.frame.dispose();
                d2.frame.dispose();
            }
        }
    }
}

