/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class ImageLoader {
    private int width = -1;
    private int height = -1;

    public ImageLoader() {
    }

    public ImageLoader(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public INDArray asRowVector(File f) throws Exception {
        return ArrayUtil.toNDArray((int[])this.flattenedImageFromFile(f));
    }

    public INDArray asImageMiniBatches(File f, int numMiniBatches, int numRowsPerSlice) {
        try {
            INDArray d = this.asMatrix(f);
            INDArray f2 = Nd4j.create((int[])new int[]{numMiniBatches, numRowsPerSlice, d.columns()});
            return f2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public INDArray asMatrix(File f) throws IOException {
        return ArrayUtil.toNDArray((int[][])this.fromFile(f));
    }

    public int[] flattenedImageFromFile(File f) throws Exception {
        return ArrayUtil.flatten((int[][])this.fromFile(f));
    }

    public int[][] fromFile(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        if (this.height > 0 && this.width > 0) {
            image = ImageLoader.toBufferedImage(image.getScaledInstance(this.height, this.width, 4));
        }
        Raster raster = image.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int[][] ret = new int[w][h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                ret[i][j] = raster.getSample(i, j, 0);
            }
        }
        return ret;
    }

    public static BufferedImage toImage(INDArray matrix) {
        BufferedImage img = new BufferedImage(matrix.rows(), matrix.columns(), 2);
        WritableRaster r = img.getRaster();
        int[] equiv = new int[matrix.length()];
        for (int i = 0; i < equiv.length; ++i) {
            equiv[i] = (Integer)matrix.getScalar(i).element();
        }
        r.setDataElements(0, 0, matrix.rows(), matrix.columns(), equiv);
        return img;
    }

    private static int[] rasterData(INDArray matrix) {
        int[] ret = new int[matrix.length()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)Math.round((Double)matrix.getScalar(i).element());
        }
        return ret;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

