/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot;

import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.mnist.draw.DrawReconstruction;
import org.deeplearning4j.models.featuredetectors.autoencoder.SemanticHashing;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.transformation.MatrixTransform;

public class DeepAutoEncoderDataSetReconstructionRender {
    private DataSetIterator iter;
    private SemanticHashing encoder;
    private int rows;
    private int columns;
    private MatrixTransform picDraw;
    private MatrixTransform reconDraw;

    public DeepAutoEncoderDataSetReconstructionRender(DataSetIterator iter, SemanticHashing encoder, int rows, int columns) {
        this.iter = iter;
        this.encoder = encoder;
        this.rows = rows;
        this.columns = columns;
    }

    public void draw() throws InterruptedException {
        while (this.iter.hasNext()) {
            DataSet first = (DataSet)this.iter.next();
            INDArray reconstruct = this.encoder.output(first.getFeatureMatrix());
            for (int j = 0; j < first.numExamples(); ++j) {
                INDArray draw1 = first.get(j).getFeatureMatrix().mul((Number)255);
                if (this.picDraw != null) {
                    draw1 = (INDArray)this.picDraw.apply((Object)draw1);
                }
                INDArray reconstructed2 = reconstruct.getRow(j);
                if (this.reconDraw != null) {
                    reconstructed2 = (INDArray)this.reconDraw.apply((Object)reconstructed2);
                }
                INDArray draw2 = reconstructed2.mul((Number)255);
                DrawReconstruction d = new DrawReconstruction(draw1.reshape(this.rows, this.columns));
                d.title = "REAL";
                d.draw();
                DrawReconstruction d2 = new DrawReconstruction(draw2.reshape(this.rows, this.columns), 1000, 1000);
                d2.title = "TEST";
                d2.draw();
                Thread.sleep(10000L);
                d.frame.dispose();
                d2.frame.dispose();
            }
        }
    }

    public MatrixTransform getPicDraw() {
        return this.picDraw;
    }

    public void setPicDraw(MatrixTransform picDraw) {
        this.picDraw = picDraw;
    }

    public MatrixTransform getReconDraw() {
        return this.reconDraw;
    }

    public void setReconDraw(MatrixTransform reconDraw) {
        this.reconDraw = reconDraw;
    }
}

