/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.optimizers;

import java.io.Serializable;
import org.deeplearning4j.nn.BaseMultiLayerNetwork;
import org.deeplearning4j.nn.api.NeuralNetwork;
import org.deeplearning4j.optimize.api.OptimizableByGradientValueMatrix;
import org.deeplearning4j.optimize.api.TrainingEvaluator;
import org.deeplearning4j.optimize.solvers.StochasticHessianFree;
import org.deeplearning4j.optimize.solvers.VectorizedDeepLearningGradientAscent;
import org.deeplearning4j.optimize.solvers.VectorizedNonZeroStoppingConjugateGradient;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPropROptimizer
implements Serializable,
OptimizableByGradientValueMatrix {
    private BaseMultiLayerNetwork network;
    private int length = -1;
    private double lr = 0.1;
    private int epochs = 1000;
    private static Logger log = LoggerFactory.getLogger(BackPropROptimizer.class);
    private int currentIteration = -1;
    private StochasticHessianFree h;

    public BackPropROptimizer(BaseMultiLayerNetwork network, double lr, int epochs) {
        this.network = network;
        this.lr = lr;
        this.epochs = epochs;
    }

    @Override
    public void setCurrentIteration(int value) {
        this.currentIteration = value;
    }

    public void optimize(TrainingEvaluator eval) {
        NeuralNetwork.OptimizationAlgorithm optimizationAlgorithm = this.network.getDefaultConfiguration().getOptimizationAlgo();
        if (optimizationAlgorithm == NeuralNetwork.OptimizationAlgorithm.CONJUGATE_GRADIENT) {
            VectorizedNonZeroStoppingConjugateGradient g = new VectorizedNonZeroStoppingConjugateGradient(this);
            g.setTrainingEvaluator(eval);
            g.setMaxIterations(this.network.getOutputLayer().conf().getNumIterations());
            g.optimize(this.network.getOutputLayer().conf().getNumIterations());
        } else if (optimizationAlgorithm == NeuralNetwork.OptimizationAlgorithm.HESSIAN_FREE) {
            this.h = new StochasticHessianFree(this, this.network);
            this.h.setTrainingEvaluator(eval);
            this.h.optimize(this.network.getOutputLayer().conf().getNumIterations());
        } else {
            VectorizedDeepLearningGradientAscent g = new VectorizedDeepLearningGradientAscent(this);
            g.setTrainingEvaluator(eval);
            g.optimize(this.network.getOutputLayer().conf().getNumIterations());
        }
    }

    public void getValueGradient(double[] buffer) {
        System.arraycopy(this.network.getBackPropRGradient(this.network.params()).data(), 0, buffer, 0, buffer.length);
    }

    @Override
    public double getValue() {
        return -this.network.score();
    }

    @Override
    public int getNumParameters() {
        if (this.length < 0) {
            this.length = this.getParameters().length();
        }
        return this.length;
    }

    public void getParameters(double[] buffer) {
        System.arraycopy(this.getParameters().data(), 0, buffer, 0, buffer.length);
    }

    @Override
    public double getParameter(int index) {
        return 0.0;
    }

    public void setParameters(double[] params) {
        this.setParameters(Nd4j.create((double[])params));
    }

    @Override
    public INDArray getParameters() {
        return this.network.params();
    }

    @Override
    public void setParameters(INDArray params) {
        this.network.setParameters(params);
    }

    @Override
    public void setParameter(int index, double value) {
    }

    @Override
    public INDArray getValueGradient(int iteration) {
        return this.network.getBackPropRGradient(this.network.params());
    }
}

