/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.gradient;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.deeplearning4j.nn.api.Persistable;
import org.deeplearning4j.nn.gradient.NeuralNetworkGradient;
import org.deeplearning4j.nn.gradient.OutputLayerGradient;

public class MultiLayerGradient
implements Persistable,
Cloneable {
    private static final long serialVersionUID = 5262146791172613616L;
    private List<NeuralNetworkGradient> gradients;
    private OutputLayerGradient logRegGradient;

    public MultiLayerGradient(List<NeuralNetworkGradient> gradients, OutputLayerGradient logRegGradient) {
        this.gradients = gradients;
        this.logRegGradient = logRegGradient;
    }

    @Override
    public void write(OutputStream os) {
        org.deeplearning4j.util.SerializationUtils.writeObject(this, os);
    }

    @Override
    public void load(InputStream is) {
        MultiLayerGradient read = (MultiLayerGradient)org.deeplearning4j.util.SerializationUtils.readObject(is);
        this.gradients = read.gradients;
        this.logRegGradient = read.logRegGradient;
    }

    public void div(int num) {
        for (NeuralNetworkGradient g : this.gradients) {
            g.div(num);
        }
    }

    public MultiLayerGradient clone() {
        return (MultiLayerGradient)SerializationUtils.clone((Serializable)this);
    }

    public void addGradient(MultiLayerGradient other) {
        for (int i = 0; i < this.gradients.size(); ++i) {
            this.gradients.get(i).add(other.getGradients().get(i));
        }
        this.logRegGradient.add(other.getLogRegGradient());
    }

    public List<NeuralNetworkGradient> getGradients() {
        return this.gradients;
    }

    public void setGradients(List<NeuralNetworkGradient> gradients) {
        this.gradients = gradients;
    }

    public OutputLayerGradient getLogRegGradient() {
        return this.logRegGradient;
    }

    public void setLogRegGradient(OutputLayerGradient logRegGradient) {
        this.logRegGradient = logRegGradient;
    }
}

