/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.models.featuredetectors.rbm.RBM;
import org.deeplearning4j.nn.WeightInit;
import org.deeplearning4j.nn.api.NeuralNetwork;
import org.nd4j.linalg.api.activation.ActivationFunction;
import org.nd4j.linalg.api.activation.Activations;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private float sparsity = 0.0f;
    private boolean useAdaGrad = true;
    private float lr = 0.1f;
    protected int k = 1;
    protected float corruptionLevel = 0.3f;
    protected int numIterations = 1000;
    protected float momentum = 0.5f;
    protected float l2 = 0.0f;
    private int pretrainEpochs = 1000;
    private int finetuneEpochs = 1000;
    private float pretrainLearningRate = 0.01f;
    private float finetuneLearningRate = 0.01f;
    protected boolean useRegularization = false;
    protected Map<Integer, Float> momentumAfter = new HashMap<Integer, Float>();
    protected int resetAdaGradIterations = -1;
    protected float dropOut = 0.0f;
    protected boolean applySparsity = false;
    protected WeightInit weightInit = WeightInit.VI;
    protected NeuralNetwork.OptimizationAlgorithm optimizationAlgo = NeuralNetwork.OptimizationAlgorithm.CONJUGATE_GRADIENT;
    protected LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
    protected int renderWeightsEveryNumEpochs = -1;
    protected boolean concatBiases = false;
    protected boolean constrainGradientToUnitNorm = false;
    protected long seed = 123L;
    protected transient RandomGenerator rng;
    protected transient RealDistribution dist;
    protected int nIn;
    protected int nOut;
    protected ActivationFunction activationFunction;
    private RBM.VisibleUnit visibleUnit = RBM.VisibleUnit.BINARY;
    private RBM.HiddenUnit hiddenUnit = RBM.HiddenUnit.BINARY;
    private ActivationType activationType = ActivationType.HIDDEN_LAYER_ACTIVATION;
    private int[] weightShape;
    private int[] filterSize = new int[]{2, 2};
    private int numFeatureMaps = 2;
    private int[] featureMapSize = new int[]{2, 2};
    private int[] stride = new int[]{2, 2};
    private int numInFeatureMaps = 2;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rng = new MersenneTwister(this.seed);
        this.dist = new UniformRealDistribution();
    }

    public NeuralNetConfiguration() {
    }

    public NeuralNetConfiguration(float sparsity, boolean useAdaGrad, float lr, int k, float corruptionLevel, int numIterations, float momentum, float l2, boolean useRegularization, Map<Integer, Float> momentumAfter, int resetAdaGradIterations, float dropOut, boolean applySparsity, WeightInit weightInit, NeuralNetwork.OptimizationAlgorithm optimizationAlgo, LossFunctions.LossFunction lossFunction, int renderWeightsEveryNumEpochs, boolean concatBiases, boolean constrainGradientToUnitNorm, RandomGenerator rng, RealDistribution dist, long seed, int nIn, int nOut, ActivationFunction activationFunction, RBM.VisibleUnit visibleUnit, RBM.HiddenUnit hiddenUnit, ActivationType activationType, int[] weightShape, int[] filterSize, int numFeatureMaps, int[] stride, int[] featureMapSize, int numInFeatureMaps) {
        this.sparsity = sparsity;
        this.useAdaGrad = useAdaGrad;
        this.lr = lr;
        this.k = k;
        this.corruptionLevel = corruptionLevel;
        this.numIterations = numIterations;
        this.momentum = momentum;
        this.l2 = l2;
        this.useRegularization = useRegularization;
        this.momentumAfter = momentumAfter;
        this.resetAdaGradIterations = resetAdaGradIterations;
        this.dropOut = dropOut;
        this.applySparsity = applySparsity;
        this.weightInit = weightInit;
        this.optimizationAlgo = optimizationAlgo;
        this.lossFunction = lossFunction;
        this.renderWeightsEveryNumEpochs = renderWeightsEveryNumEpochs;
        this.concatBiases = concatBiases;
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
        this.rng = rng;
        this.dist = dist;
        this.seed = seed;
        this.nIn = nIn;
        this.nOut = nOut;
        this.activationFunction = activationFunction;
        this.visibleUnit = visibleUnit;
        this.hiddenUnit = hiddenUnit;
        this.activationType = activationType;
        this.weightShape = weightShape != null ? weightShape : new int[]{nIn, nOut};
        this.filterSize = filterSize;
        this.numFeatureMaps = numFeatureMaps;
        this.stride = stride;
        this.featureMapSize = featureMapSize;
        this.numInFeatureMaps = numInFeatureMaps;
    }

    public NeuralNetConfiguration(NeuralNetConfiguration neuralNetConfiguration) {
        this.sparsity = neuralNetConfiguration.sparsity;
        this.useAdaGrad = neuralNetConfiguration.useAdaGrad;
        this.lr = neuralNetConfiguration.lr;
        this.momentum = neuralNetConfiguration.momentum;
        this.l2 = neuralNetConfiguration.l2;
        this.numIterations = neuralNetConfiguration.numIterations;
        this.k = neuralNetConfiguration.k;
        this.corruptionLevel = neuralNetConfiguration.corruptionLevel;
        this.visibleUnit = neuralNetConfiguration.visibleUnit;
        this.hiddenUnit = neuralNetConfiguration.hiddenUnit;
        this.useRegularization = neuralNetConfiguration.useRegularization;
        this.momentumAfter = neuralNetConfiguration.momentumAfter;
        this.resetAdaGradIterations = neuralNetConfiguration.resetAdaGradIterations;
        this.dropOut = neuralNetConfiguration.dropOut;
        this.applySparsity = neuralNetConfiguration.applySparsity;
        this.weightInit = neuralNetConfiguration.weightInit;
        this.optimizationAlgo = neuralNetConfiguration.optimizationAlgo;
        this.lossFunction = neuralNetConfiguration.lossFunction;
        this.renderWeightsEveryNumEpochs = neuralNetConfiguration.renderWeightsEveryNumEpochs;
        this.concatBiases = neuralNetConfiguration.concatBiases;
        this.constrainGradientToUnitNorm = neuralNetConfiguration.constrainGradientToUnitNorm;
        this.rng = neuralNetConfiguration.rng;
        this.dist = neuralNetConfiguration.dist;
        this.seed = neuralNetConfiguration.seed;
        this.nIn = neuralNetConfiguration.nIn;
        this.nOut = neuralNetConfiguration.nOut;
        this.activationFunction = neuralNetConfiguration.activationFunction;
        this.visibleUnit = neuralNetConfiguration.visibleUnit;
        this.activationType = neuralNetConfiguration.activationType;
        this.weightShape = neuralNetConfiguration.weightShape;
        this.stride = neuralNetConfiguration.stride;
        this.numFeatureMaps = neuralNetConfiguration.numFeatureMaps;
        this.filterSize = neuralNetConfiguration.filterSize;
        this.featureMapSize = neuralNetConfiguration.featureMapSize;
        if (this.dist == null) {
            this.dist = new NormalDistribution(this.rng, 0.0, 0.01, 1.0E-9);
        }
        this.hiddenUnit = neuralNetConfiguration.hiddenUnit;
    }

    public int getNumInFeatureMaps() {
        return this.numInFeatureMaps;
    }

    public void setNumInFeatureMaps(int numInFeatureMaps) {
        this.numInFeatureMaps = numInFeatureMaps;
    }

    public int[] getFeatureMapSize() {
        return this.featureMapSize;
    }

    public void setFeatureMapSize(int[] featureMapSize) {
        this.featureMapSize = featureMapSize;
    }

    public int[] getWeightShape() {
        return this.weightShape;
    }

    public void setWeightShape(int[] weightShape) {
        this.weightShape = weightShape;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public float getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public void setCorruptionLevel(float corruptionLevel) {
        this.corruptionLevel = corruptionLevel;
    }

    public RBM.HiddenUnit getHiddenUnit() {
        return this.hiddenUnit;
    }

    public void setHiddenUnit(RBM.HiddenUnit hiddenUnit) {
        this.hiddenUnit = hiddenUnit;
    }

    public RBM.VisibleUnit getVisibleUnit() {
        return this.visibleUnit;
    }

    public void setVisibleUnit(RBM.VisibleUnit visibleUnit) {
        this.visibleUnit = visibleUnit;
    }

    public LossFunctions.LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public void setLossFunction(LossFunctions.LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public int getnIn() {
        return this.nIn;
    }

    public void setnIn(int nIn) {
        this.nIn = nIn;
    }

    public int getnOut() {
        return this.nOut;
    }

    public void setnOut(int nOut) {
        this.nOut = nOut;
    }

    public float getSparsity() {
        return this.sparsity;
    }

    public void setSparsity(float sparsity) {
        this.sparsity = sparsity;
    }

    public boolean isUseAdaGrad() {
        return this.useAdaGrad;
    }

    public void setUseAdaGrad(boolean useAdaGrad) {
        this.useAdaGrad = useAdaGrad;
    }

    public float getLr() {
        return this.lr;
    }

    public void setLr(float lr) {
        this.lr = lr;
    }

    public float getMomentum() {
        return this.momentum;
    }

    public void setMomentum(float momentum) {
        this.momentum = momentum;
    }

    public float getL2() {
        return this.l2;
    }

    public void setL2(float l2) {
        this.l2 = l2;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public Map<Integer, Float> getMomentumAfter() {
        return this.momentumAfter;
    }

    public void setMomentumAfter(Map<Integer, Float> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public int getResetAdaGradIterations() {
        return this.resetAdaGradIterations;
    }

    public void setResetAdaGradIterations(int resetAdaGradIterations) {
        this.resetAdaGradIterations = resetAdaGradIterations;
    }

    public float getDropOut() {
        return this.dropOut;
    }

    public void setDropOut(float dropOut) {
        this.dropOut = dropOut;
    }

    public boolean isApplySparsity() {
        return this.applySparsity;
    }

    public void setApplySparsity(boolean applySparsity) {
        this.applySparsity = applySparsity;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public NeuralNetwork.OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public void setOptimizationAlgo(NeuralNetwork.OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public int getRenderWeightsEveryNumEpochs() {
        return this.renderWeightsEveryNumEpochs;
    }

    public void setRenderWeightIterations(int renderWeightsEveryNumEpochs) {
        this.renderWeightsEveryNumEpochs = renderWeightsEveryNumEpochs;
    }

    public boolean isConcatBiases() {
        return this.concatBiases;
    }

    public void setConcatBiases(boolean concatBiases) {
        this.concatBiases = concatBiases;
    }

    public boolean isConstrainGradientToUnitNorm() {
        return this.constrainGradientToUnitNorm;
    }

    public void setConstrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
        this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
    }

    public RandomGenerator getRng() {
        return this.rng;
    }

    public void setRng(RandomGenerator rng) {
        this.rng = rng;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public RealDistribution getDist() {
        return this.dist;
    }

    public void setDist(RealDistribution dist) {
        this.dist = dist;
    }

    public ActivationType getActivationType() {
        return this.activationType;
    }

    public void setActivationType(ActivationType activationType) {
        this.activationType = activationType;
    }

    public int[] getFilterSize() {
        return this.filterSize;
    }

    public void setFilterSize(int[] filterSize) {
        this.filterSize = filterSize;
    }

    public int getNumFeatureMaps() {
        return this.numFeatureMaps;
    }

    public void setNumFeatureMaps(int numFeatureMaps) {
        this.numFeatureMaps = numFeatureMaps;
    }

    public int[] getStride() {
        return this.stride;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public int getPretrainEpochs() {
        return this.pretrainEpochs;
    }

    public void setPretrainEpochs(int pretrainEpochs) {
        this.pretrainEpochs = pretrainEpochs;
    }

    public void setPretrainLearningRate(float pretrainLearningRate) {
        this.pretrainLearningRate = pretrainLearningRate;
    }

    public float getFinetuneLearningRate() {
        return this.finetuneLearningRate;
    }

    public void setFinetuneLearningRate(float finetuneLearningRate) {
        this.finetuneLearningRate = finetuneLearningRate;
    }

    public int getFinetuneEpochs() {
        return this.finetuneEpochs;
    }

    public void setFinetuneEpochs(int finetuneEpochs) {
        this.finetuneEpochs = finetuneEpochs;
    }

    public String toString() {
        return "NeuralNetConfiguration{sparsity=" + this.sparsity + ", useAdaGrad=" + this.useAdaGrad + ", lr=" + this.lr + ", k=" + this.k + ", corruptionLevel=" + this.corruptionLevel + ", numIterations=" + this.numIterations + ", momentum=" + this.momentum + ", l2=" + this.l2 + ", useRegularization=" + this.useRegularization + ", momentumAfter=" + this.momentumAfter + ", resetAdaGradIterations=" + this.resetAdaGradIterations + ", dropOut=" + this.dropOut + ", applySparsity=" + this.applySparsity + ", weightInit=" + (Object)((Object)this.weightInit) + ", optimizationAlgo=" + (Object)((Object)this.optimizationAlgo) + ", lossFunction=" + this.lossFunction + ", renderWeightsEveryNumEpochs=" + this.renderWeightsEveryNumEpochs + ", concatBiases=" + this.concatBiases + ", constrainGradientToUnitNorm=" + this.constrainGradientToUnitNorm + ", rng=" + this.rng + ", dist=" + this.dist + ", seed=" + this.seed + ", nIn=" + this.nIn + ", nOut=" + this.nOut + ", activationFunction=" + this.activationFunction + ", visibleUnit=" + (Object)((Object)this.visibleUnit) + ", hiddenUnit=" + (Object)((Object)this.hiddenUnit) + ", activationType=" + (Object)((Object)this.activationType) + ", weightShape=" + Arrays.toString(this.weightShape) + ", filterSize=" + Arrays.toString(this.filterSize) + ", numFeatureMaps=" + this.numFeatureMaps + ", featureMapSize=" + Arrays.toString(this.featureMapSize) + ", stride=" + Arrays.toString(this.stride) + ", numInFeatureMaps=" + this.numInFeatureMaps + '}';
    }

    public static void setClassifier(NeuralNetConfiguration conf) {
        NeuralNetConfiguration.setClassifier(conf, true);
    }

    public static void setClassifier(NeuralNetConfiguration conf, boolean rows) {
        conf.setActivationFunction(rows ? Activations.softMaxRows() : Activations.softmax());
        conf.setLossFunction(LossFunctions.LossFunction.MCXENT);
        conf.setWeightInit(WeightInit.ZERO);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration that = (NeuralNetConfiguration)o;
        if (this.applySparsity != that.applySparsity) {
            return false;
        }
        if (this.concatBiases != that.concatBiases) {
            return false;
        }
        if (this.constrainGradientToUnitNorm != that.constrainGradientToUnitNorm) {
            return false;
        }
        if (Float.compare(that.corruptionLevel, this.corruptionLevel) != 0) {
            return false;
        }
        if (Float.compare(that.dropOut, this.dropOut) != 0) {
            return false;
        }
        if (this.k != that.k) {
            return false;
        }
        if (Float.compare(that.l2, this.l2) != 0) {
            return false;
        }
        if (Float.compare(that.lr, this.lr) != 0) {
            return false;
        }
        if (Float.compare(that.momentum, this.momentum) != 0) {
            return false;
        }
        if (this.nIn != that.nIn) {
            return false;
        }
        if (this.nOut != that.nOut) {
            return false;
        }
        if (this.numIterations != that.numIterations) {
            return false;
        }
        if (this.renderWeightsEveryNumEpochs != that.renderWeightsEveryNumEpochs) {
            return false;
        }
        if (this.resetAdaGradIterations != that.resetAdaGradIterations) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        if (Float.compare(that.sparsity, this.sparsity) != 0) {
            return false;
        }
        if (this.useAdaGrad != that.useAdaGrad) {
            return false;
        }
        if (this.useRegularization != that.useRegularization) {
            return false;
        }
        if (!this.activationFunction.equals(that.activationFunction)) {
            return false;
        }
        if (this.dist != null ? !this.dist.equals(that.dist) : that.dist != null) {
            return false;
        }
        if (this.hiddenUnit != that.hiddenUnit) {
            return false;
        }
        if (this.lossFunction != that.lossFunction) {
            return false;
        }
        if (this.momentumAfter != null ? !this.momentumAfter.equals(that.momentumAfter) : that.momentumAfter != null) {
            return false;
        }
        if (this.optimizationAlgo != that.optimizationAlgo) {
            return false;
        }
        if (this.rng != null ? !this.rng.equals(that.rng) : that.rng != null) {
            return false;
        }
        if (this.visibleUnit != that.visibleUnit) {
            return false;
        }
        return this.weightInit == that.weightInit;
    }

    public int hashCode() {
        int result = this.sparsity != 0.0f ? Float.floatToIntBits(this.sparsity) : 0;
        result = 31 * result + (this.useAdaGrad ? 1 : 0);
        result = 31 * result + (this.lr != 0.0f ? Float.floatToIntBits(this.lr) : 0);
        result = 31 * result + this.k;
        result = 31 * result + (this.corruptionLevel != 0.0f ? Float.floatToIntBits(this.corruptionLevel) : 0);
        result = 31 * result + this.numIterations;
        result = 31 * result + (this.momentum != 0.0f ? Float.floatToIntBits(this.momentum) : 0);
        result = 31 * result + (this.l2 != 0.0f ? Float.floatToIntBits(this.l2) : 0);
        result = 31 * result + (this.useRegularization ? 1 : 0);
        result = 31 * result + (this.momentumAfter != null ? this.momentumAfter.hashCode() : 0);
        result = 31 * result + this.resetAdaGradIterations;
        result = 31 * result + (this.dropOut != 0.0f ? Float.floatToIntBits(this.dropOut) : 0);
        result = 31 * result + (this.applySparsity ? 1 : 0);
        result = 31 * result + this.weightInit.hashCode();
        result = 31 * result + this.optimizationAlgo.hashCode();
        result = 31 * result + this.lossFunction.hashCode();
        result = 31 * result + this.renderWeightsEveryNumEpochs;
        result = 31 * result + (this.concatBiases ? 1 : 0);
        result = 31 * result + (this.constrainGradientToUnitNorm ? 1 : 0);
        result = 31 * result + (this.rng != null ? this.rng.hashCode() : 0);
        result = 31 * result + (this.dist != null ? this.dist.hashCode() : 0);
        result = 31 * result + (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + this.nIn;
        result = 31 * result + this.nOut;
        result = 31 * result + this.activationFunction.hashCode();
        result = 31 * result + this.visibleUnit.hashCode();
        result = 31 * result + this.hiddenUnit.hashCode();
        return result;
    }

    public NeuralNetConfiguration clone() {
        return new NeuralNetConfiguration(this);
    }

    public static class Builder {
        private int k = 1;
        private float corruptionLevel = 0.3f;
        private float sparsity = 0.0f;
        private boolean useAdaGrad = true;
        private float lr = 0.1f;
        private float momentum = 0.5f;
        private float l2 = 0.0f;
        private boolean useRegularization = false;
        private Map<Integer, Float> momentumAfter;
        private int resetAdaGradIterations = -1;
        private float dropOut = 0.0f;
        private boolean applySparsity = false;
        private WeightInit weightInit = WeightInit.VI;
        private NeuralNetwork.OptimizationAlgorithm optimizationAlgo = NeuralNetwork.OptimizationAlgorithm.CONJUGATE_GRADIENT;
        private int renderWeightsEveryNumEpochs = -1;
        private boolean concatBiases = false;
        private boolean constrainGradientToUnitNorm = true;
        private RandomGenerator rng = new MersenneTwister(123);
        private long seed = 123L;
        private RealDistribution dist = new NormalDistribution(this.rng, 0.0, 0.01, 1.0E-9);
        private boolean adagrad = true;
        private LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
        private int nIn;
        private int nOut;
        private ActivationFunction activationFunction = Activations.sigmoid();
        private RBM.VisibleUnit visibleUnit = RBM.VisibleUnit.BINARY;
        private RBM.HiddenUnit hiddenUnit = RBM.HiddenUnit.BINARY;
        private int numIterations = 1000;
        private ActivationType activationType = ActivationType.HIDDEN_LAYER_ACTIVATION;
        private int[] weightShape;
        private int[] filterSize;
        private int numFeatureMaps = 2;
        private int[] featureMapSize = new int[]{2, 2};
        private int numInFeatureMaps = 2;
        private int[] stride;

        public ListBuilder list(int size) {
            ArrayList<Builder> list = new ArrayList<Builder>();
            for (int i = 0; i < size; ++i) {
                list.add(this.clone());
            }
            return new ListBuilder(list);
        }

        public Builder clone() {
            Builder b = new Builder().activationFunction(this.activationFunction).adagradResetIterations(this.resetAdaGradIterations).applySparsity(this.applySparsity).concatBiases(this.concatBiases).constrainGradientToUnitNorm(this.constrainGradientToUnitNorm).dist(this.dist).dropOut(this.dropOut).featureMapSize(this.featureMapSize).filterSize(this.filterSize).hiddenUnit(this.hiddenUnit).iterations(this.numIterations).l2(this.l2).learningRate(this.lr).lossFunction(this.lossFunction).momentumAfter(this.momentumAfter).momentum(this.momentum).nIn(this.nIn).nOut(this.nOut).numFeatureMaps(this.numFeatureMaps).optimizationAlgo(this.optimizationAlgo).regularization(this.useRegularization).render(this.renderWeightsEveryNumEpochs).resetAdaGradIterations(this.resetAdaGradIterations).rng(this.rng).seed(this.seed).sparsity(this.sparsity).stride(this.stride).useAdaGrad(this.useAdaGrad).visibleUnit(this.visibleUnit).weightInit(this.weightInit).weightShape(this.weightShape).withActivationType(this.activationType);
            return b;
        }

        public Builder numInFeatureMaps(int numInFeatureMaps) {
            this.numInFeatureMaps = numInFeatureMaps;
            return this;
        }

        public Builder featureMapSize(int[] featureMapSize) {
            this.featureMapSize = featureMapSize;
            return this;
        }

        public Builder stride(int[] stride) {
            this.stride = stride;
            return this;
        }

        public Builder numFeatureMaps(int numFeatureMaps) {
            this.numFeatureMaps = numFeatureMaps;
            return this;
        }

        public Builder filterSize(int[] filterSize) {
            if (filterSize == null) {
                return this;
            }
            if (filterSize == null || filterSize.length != 2) {
                throw new IllegalArgumentException("Invalid filter size must be length 2");
            }
            this.filterSize = filterSize;
            return this;
        }

        public Builder weightShape(int[] weightShape) {
            this.weightShape = weightShape;
            return this;
        }

        public Builder withActivationType(ActivationType activationType) {
            this.activationType = activationType;
            return this;
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder dist(RealDistribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder sparsity(float sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        public Builder useAdaGrad(boolean useAdaGrad) {
            this.useAdaGrad = useAdaGrad;
            return this;
        }

        public Builder learningRate(float lr) {
            this.lr = lr;
            return this;
        }

        public Builder momentum(float momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder momentumAfter(Map<Integer, Float> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return this;
        }

        public Builder adagradResetIterations(int resetAdaGradIterations) {
            this.resetAdaGradIterations = resetAdaGradIterations;
            return this;
        }

        public Builder dropOut(float dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder applySparsity(boolean applySparsity) {
            this.applySparsity = applySparsity;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder render(int renderWeightsEveryNumEpochs) {
            this.renderWeightsEveryNumEpochs = renderWeightsEveryNumEpochs;
            return this;
        }

        public Builder concatBiases(boolean concatBiases) {
            this.concatBiases = concatBiases;
            return this;
        }

        public Builder rng(RandomGenerator rng) {
            this.rng = rng;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public NeuralNetConfiguration build() {
            NeuralNetConfiguration ret = new NeuralNetConfiguration(this.sparsity, this.useAdaGrad, this.lr, this.k, this.corruptionLevel, this.numIterations, this.momentum, this.l2, this.useRegularization, this.momentumAfter, this.resetAdaGradIterations, this.dropOut, this.applySparsity, this.weightInit, this.optimizationAlgo, this.lossFunction, this.renderWeightsEveryNumEpochs, this.concatBiases, this.constrainGradientToUnitNorm, this.rng, this.dist, this.seed, this.nIn, this.nOut, this.activationFunction, this.visibleUnit, this.hiddenUnit, this.activationType, this.weightShape, this.filterSize, this.numFeatureMaps, this.stride, this.featureMapSize, this.numInFeatureMaps);
            return ret;
        }

        public Builder l2(float l2) {
            this.l2 = l2;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder resetAdaGradIterations(int resetAdaGradIterations) {
            this.resetAdaGradIterations = resetAdaGradIterations;
            return this;
        }

        public Builder optimizationAlgo(NeuralNetwork.OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder lossFunction(LossFunctions.LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return this;
        }

        public Builder constrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
            this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
            return this;
        }

        public Builder nIn(int nIn) {
            this.nIn = nIn;
            return this;
        }

        public Builder nOut(int nOut) {
            this.nOut = nOut;
            return this;
        }

        public Builder activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        public Builder visibleUnit(RBM.VisibleUnit visibleUnit) {
            this.visibleUnit = visibleUnit;
            return this;
        }

        public Builder hiddenUnit(RBM.HiddenUnit hiddenUnit) {
            this.hiddenUnit = hiddenUnit;
            return this;
        }
    }

    public static class ListBuilder {
        private List<Builder> layerwise;

        public ListBuilder(List<Builder> list) {
            this.layerwise = list;
        }

        public ListBuilder override(ConfOverride override) {
            for (int i = 0; i < this.layerwise.size(); ++i) {
                override.override(i, this.layerwise.get(i));
            }
            return this;
        }

        public List<NeuralNetConfiguration> build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            for (int i = 0; i < this.layerwise.size(); ++i) {
                list.add(this.layerwise.get(i).build());
            }
            return list;
        }
    }

    public static interface ConfOverride {
        public void override(int var1, Builder var2);
    }

    public static enum ActivationType {
        NET_ACTIVATION,
        HIDDEN_LAYER_ACTIVATION,
        SAMPLE;

    }
}

