/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.vectorizer;

import java.io.File;
import org.deeplearning4j.datasets.vectorizer.Vectorizer;
import org.deeplearning4j.util.ImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.util.FeatureUtil;

public class ImageVectorizer
implements Vectorizer {
    private File image;
    private ImageLoader loader = new ImageLoader();
    private boolean binarize;
    private boolean normalize;
    private int label;
    private int numLabels;
    private int threshold = 30;

    public ImageVectorizer(File image, int numLabels, int label) {
        this.image = image;
        this.numLabels = numLabels;
        this.label = label;
    }

    public ImageVectorizer binarize(int threshold) {
        this.binarize = true;
        this.normalize = false;
        return this;
    }

    public ImageVectorizer binarize() {
        return this.binarize(30);
    }

    public ImageVectorizer normalize() {
        this.binarize = false;
        this.normalize = true;
        return this;
    }

    @Override
    public DataSet vectorize() {
        try {
            INDArray d = this.loader.asMatrix(this.image);
            INDArray label2 = FeatureUtil.toOutcomeVector((int)this.label, (int)this.numLabels);
            if (this.normalize) {
                d = d.div((Number)255);
            } else if (this.binarize) {
                for (int i = 0; i < d.length(); ++i) {
                    double curr = (Double)d.getScalar(i).element();
                    if (curr > (double)this.threshold) {
                        d.putScalar(i, 1);
                        continue;
                    }
                    d.putScalar(i, 0);
                }
            }
            return new DataSet(d, label2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

