/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import org.apache.commons.math3.util.FastMath;
import org.deeplearning4j.optimize.api.OptimizableByGradientValueMatrix;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedBackTrackLineSearchMinimum {
    private static Logger logger = LoggerFactory.getLogger((String)VectorizedBackTrackLineSearchMinimum.class.getName());
    OptimizableByGradientValueMatrix function;
    final int maxIterations = 100;
    double stpmax = 100.0;
    final double EPS = 3.0E-12;
    private double relTolx = 1.0E-10;
    private double absTolx = 1.0E-4;
    final double ALF = 1.0E-4;

    public VectorizedBackTrackLineSearchMinimum(OptimizableByGradientValueMatrix optimizable) {
        this.function = optimizable;
    }

    public void setStpmax(double stpmax) {
        this.stpmax = stpmax;
    }

    public double getStpmax() {
        return this.stpmax;
    }

    public void setRelTolx(double tolx) {
        this.relTolx = tolx;
    }

    public void setAbsTolx(double tolx) {
        this.absTolx = tolx;
    }

    public double optimize(INDArray line, int lineSearchIteration, INDArray g, INDArray params) {
        double fold;
        INDArray oldParameters = params.dup();
        double tmplam = 0.0;
        double alam2 = 0.0;
        double f2 = fold = this.function.getValue();
        if (logger.isDebugEnabled()) {
            logger.trace("ENTERING BACKTRACK\n");
            logger.trace("Entering BackTrackLnSrch, value=" + fold + ",\ndirection.oneNorm:" + line.norm1(Integer.MAX_VALUE) + "  direction.infNorm:" + FastMath.max((double)Double.NEGATIVE_INFINITY, (double)((Double)Transforms.abs((INDArray)line).max(Integer.MAX_VALUE).element())));
        }
        LinAlgExceptions.assertValidNum((INDArray)g);
        double sum = (Double)line.norm2(Integer.MAX_VALUE).element();
        double slope = Nd4j.getBlasWrapper().dot(g, line);
        logger.debug("slope = " + slope);
        INDArray maxOldParams = Nd4j.create((int)line.length());
        for (int i = 0; i < line.length(); ++i) {
            maxOldParams.putScalar(i, Math.max(Math.abs((Double)oldParameters.getScalar(i).element()), 1.0));
        }
        INDArray testMatrix = Transforms.abs((INDArray)line).div(maxOldParams);
        double test = (Double)testMatrix.max(Integer.MAX_VALUE).element();
        double alamin = this.relTolx / test;
        double alam = 1.0;
        double oldAlam = 0.0;
        int iteration = 0;
        for (iteration = 0; iteration < 100; ++iteration) {
            double f;
            this.function.setCurrentIteration(lineSearchIteration);
            logger.trace("BackTrack loop iteration " + iteration + " : alam=" + alam + " oldAlam=" + oldAlam);
            logger.trace("before step, x.1norm: " + params.norm1(Integer.MAX_VALUE) + "\nalam: " + alam + "\noldAlam: " + oldAlam);
            assert (alam != oldAlam) : "alam == oldAlam";
            params.addi(line.mul((Number)(alam - oldAlam)));
            logger.debug("after step, x.1norm: " + params.norm1(Integer.MAX_VALUE));
            if (alam < alamin || this.smallAbsDiff(oldParameters, params)) {
                this.function.setParameters(oldParameters);
                f = this.function.getValue();
                logger.trace("EXITING BACKTRACK: Jump too small (alamin=" + alamin + "). Exiting and using xold. Value=" + f);
                return 0.0;
            }
            this.function.setParameters(params);
            oldAlam = alam;
            f = this.function.getValue();
            logger.debug("value = " + f);
            if (f >= fold + 1.0E-4 * alam * slope) {
                logger.debug("EXITING BACKTRACK: value=" + f);
                if (f < fold) {
                    throw new IllegalStateException("Function did not increase: f=" + f + " < " + fold + "=fold");
                }
                return alam;
            }
            if (Double.isInfinite(f) || Double.isInfinite(f2)) {
                logger.warn("Value is infinite after jump " + oldAlam + ". f=" + f + ", f2=" + f2 + ". Scaling back step size...");
                tmplam = 0.2 * alam;
                if (alam < alamin) {
                    this.function.setParameters(oldParameters);
                    f = this.function.getValue();
                    logger.warn("EXITING BACKTRACK: Jump too small. Exiting and using xold. Value=" + f);
                    return 0.0;
                }
            } else if (alam == 1.0) {
                tmplam = -slope / (2.0 * (f - fold - slope));
            } else {
                double disc;
                double rhs1 = f - fold - alam * slope;
                double rhs2 = f2 - fold - alam2 * slope;
                assert (alam - alam2 != 0.0) : "FAILURE: dividing by alam-alam2. alam=" + alam;
                double a = (rhs1 / FastMath.pow((double)alam, (int)2) - rhs2 / FastMath.pow((double)alam2, (int)2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmplam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + FastMath.sqrt((double)disc)) / (3.0 * a) : -slope / (b + FastMath.sqrt((double)disc))));
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            logger.debug("tmplam:" + tmplam);
            alam = Math.max(tmplam, 0.1 * alam);
        }
        if (iteration >= 100) {
            throw new IllegalStateException("Too many iterations.");
        }
        return 0.0;
    }

    private boolean smallAbsDiff(INDArray x, INDArray xold) {
        for (int i = 0; i < x.length(); ++i) {
            double comp = Math.abs((Double)x.getScalar(i).sub(xold.getScalar(i)).element());
            if (!(comp > this.absTolx)) continue;
            return false;
        }
        return true;
    }
}

