/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.distributions;

import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.util.MultiDimensionalMap;

public class Distributions {
    private static MultiDimensionalMap<RandomGenerator, Double, RealDistribution> normalDistributions = MultiDimensionalMap.newHashBackedMap();
    private static MultiDimensionalMap<RandomGenerator, Double, RealDistribution> exponentialDist = MultiDimensionalMap.newHashBackedMap();
    private static MultiDimensionalMap<RandomGenerator, Double, RealDistribution> uniformDist = MultiDimensionalMap.newHashBackedMap();

    public static RealDistribution exponential(RandomGenerator rng, double mean) {
        if (exponentialDist.get(rng, mean) == null) {
            ExponentialDistribution ret = new ExponentialDistribution(rng, 1.0, 1.0E-9);
            exponentialDist.put(rng, mean, (RealDistribution)ret);
        }
        return exponentialDist.get(rng, mean);
    }

    public static RealDistribution normal(RandomGenerator rng, double std) {
        if (normalDistributions.get(rng, std) == null) {
            NormalDistribution ret = new NormalDistribution(rng, 0.0, std, 1.0E-9);
            normalDistributions.put(rng, std, (RealDistribution)ret);
            return ret;
        }
        return normalDistributions.get(rng, std);
    }

    public static RealDistribution uniform(RandomGenerator rng, double fanIn) {
        if (uniformDist.get(rng, fanIn = Math.abs(fanIn)) == null) {
            UniformRealDistribution ret = new UniformRealDistribution(rng, -fanIn, fanIn);
            uniformDist.put(rng, fanIn, (RealDistribution)ret);
            return ret;
        }
        return uniformDist.get(rng, fanIn);
    }

    public static RealDistribution uniform(RandomGenerator rng, double fanIn, double fanOut) {
        fanIn = Math.abs(fanIn);
        return new UniformRealDistribution(rng, fanIn, fanOut);
    }

    public static RealDistribution uniform(RandomGenerator rng, int nIn, int nOut) {
        double fanIn = -4.0 * Math.sqrt(6.0 / (double)(nOut + nIn));
        return Distributions.uniform(rng, fanIn);
    }

    public static RealDistribution uniform(RandomGenerator rng) {
        double fanIn = 0.1;
        return new UniformRealDistribution(rng, -fanIn, fanIn);
    }
}

