/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.deeplearning4j.util.ArrayUtil;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;

public class ImageLoader {
    private int width = -1;
    private int height = -1;

    public ImageLoader() {
    }

    public ImageLoader(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public DoubleMatrix asRowVector(File f) throws Exception {
        return MatrixUtil.toMatrix(this.flattenedImageFromFile(f));
    }

    public DoubleMatrix asMatrix(File f) throws IOException {
        return MatrixUtil.toMatrix(this.fromFile(f));
    }

    public int[] flattenedImageFromFile(File f) throws Exception {
        return ArrayUtil.flatten(this.fromFile(f));
    }

    public int[][] fromFile(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        if (this.height > 0 && this.width > 0) {
            image = ImageLoader.toBufferedImage(image.getScaledInstance(this.height, this.width, 4));
        }
        Raster raster = image.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int[][] ret = new int[w][h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                ret[i][j] = raster.getSample(i, j, 0);
            }
        }
        return ret;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

