/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize;

import org.deeplearning4j.optimize.LineOptimizerMatrix;
import org.deeplearning4j.optimize.NeuralNetEpochListener;
import org.deeplearning4j.optimize.OptimizableByGradientValueMatrix;
import org.deeplearning4j.optimize.VectorizedBackTrackLineSearch;
import org.deeplearning4j.util.MatrixUtil;
import org.deeplearning4j.util.OptimizerMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jblas.SimpleBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedNonZeroStoppingConjugateGradient
implements OptimizerMatrix {
    private static Logger logger = LoggerFactory.getLogger(VectorizedNonZeroStoppingConjugateGradient.class);
    boolean converged = false;
    OptimizableByGradientValueMatrix optimizable;
    VectorizedBackTrackLineSearch lineMaximizer;
    double initialStepSize = 1.0;
    double tolerance = 1.0E-5;
    double gradientTolerance = 1.0E-5;
    int maxIterations = 10000;
    private String myName = "";
    private NeuralNetEpochListener listener;
    final double eps = 1.0E-10;
    double fp;
    double gg;
    double gam;
    double dgg;
    double step;
    double fret;
    DoubleMatrix xi;
    DoubleMatrix g;
    DoubleMatrix h;
    int j;
    int iterations;

    public VectorizedNonZeroStoppingConjugateGradient(OptimizableByGradientValueMatrix function, double initialStepSize) {
        this.initialStepSize = initialStepSize;
        this.optimizable = function;
        this.lineMaximizer = new VectorizedBackTrackLineSearch(function);
        this.lineMaximizer.setAbsTolx(this.tolerance);
    }

    public VectorizedNonZeroStoppingConjugateGradient(OptimizableByGradientValueMatrix function, NeuralNetEpochListener listener) {
        this(function, 0.01);
        this.listener = listener;
    }

    public VectorizedNonZeroStoppingConjugateGradient(OptimizableByGradientValueMatrix function, double initialStepSize, NeuralNetEpochListener listener) {
        this(function, initialStepSize);
        this.listener = listener;
    }

    public VectorizedNonZeroStoppingConjugateGradient(OptimizableByGradientValueMatrix function) {
        this(function, 0.01);
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    public void setLineMaximizer(LineOptimizerMatrix lineMaximizer) {
        this.lineMaximizer = (VectorizedBackTrackLineSearch)lineMaximizer;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStepSize = initialStepSize;
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public double getStepSize() {
        return this.step;
    }

    @Override
    public boolean optimize() {
        return this.optimize(this.maxIterations);
    }

    public void setTolerance(double t) {
        this.tolerance = t;
    }

    @Override
    public boolean optimize(int numIterations) {
        this.myName = Thread.currentThread().getName();
        if (this.converged) {
            return true;
        }
        long last = System.currentTimeMillis();
        if (this.xi == null) {
            this.fp = this.optimizable.getValue();
            this.xi = this.optimizable.getValueGradient();
            this.g = this.xi.dup();
            this.h = this.xi.dup();
            this.iterations = 0;
        }
        long curr = 0L;
        for (int iterationCount = 0; iterationCount < numIterations; ++iterationCount) {
            curr = System.currentTimeMillis();
            if (this.listener != null) {
                this.listener.epochDone(iterationCount);
            }
            logger.info(this.myName + " ConjugateGradient: At iteration " + this.iterations + ", cost = " + this.fp + " -" + (curr - last));
            last = curr;
            try {
                this.step = this.lineMaximizer.optimize(this.xi, this.step);
            }
            catch (Throwable e) {
                logger.warn("Error during computation", e);
            }
            this.fret = this.optimizable.getValue();
            this.xi = this.optimizable.getValueGradient();
            if (0.0 < this.tolerance && 2.0 * Math.abs(this.fret - this.fp) <= this.tolerance * (Math.abs(this.fret) + Math.abs(this.fp) + 1.0E-10)) {
                logger.info("ConjugateGradient converged: old value= " + this.fp + " new value= " + this.fret + " tolerance=" + this.tolerance);
                this.converged = true;
                return true;
            }
            this.fp = this.fret;
            double twoNorm = this.xi.norm2();
            if (twoNorm < this.gradientTolerance) {
                logger.info("ConjugateGradient converged: gradient two norm " + twoNorm + ", less than " + this.gradientTolerance);
                this.converged = true;
                return true;
            }
            this.gg = 0.0;
            this.dgg = 0.0;
            this.gg = MatrixFunctions.pow((DoubleMatrix)this.g, (double)2.0).sum();
            this.dgg = this.xi.mul(this.xi.sub(this.g)).sum();
            this.gam = this.dgg / this.gg;
            this.g = this.xi.dup();
            this.h = this.xi.dup().add(this.h.mul(this.gam));
            assert (!MatrixUtil.isNaN(this.h));
            if (SimpleBlas.dot((DoubleMatrix)this.xi, (DoubleMatrix)this.h) > 0.0) {
                this.xi = this.h.dup();
            } else {
                logger.warn("Reverting back to GA");
                this.h = this.xi.dup();
            }
            ++this.iterations;
            if (this.iterations > this.maxIterations) {
                logger.info("Passed max umber of iterations");
                this.converged = true;
                return true;
            }
            if (this.listener == null) continue;
            this.listener.epochDone(iterationCount);
        }
        return false;
    }

    public void reset() {
        this.xi = null;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

