/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize;

import org.deeplearning4j.optimize.NeuralNetEpochListener;
import org.deeplearning4j.optimize.OptimizableByGradientValueMatrix;
import org.deeplearning4j.optimize.VectorizedBackTrackLineSearch;
import org.deeplearning4j.util.OptimizerMatrix;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedDeepLearningGradientAscent
implements OptimizerMatrix {
    private NeuralNetEpochListener listener;
    boolean converged = false;
    OptimizableByGradientValueMatrix optimizable;
    private double maxStep = 1.0;
    static final double initialStepSize = 0.2;
    double tolerance = 1.0E-5;
    int maxIterations = 200;
    VectorizedBackTrackLineSearch lineMaximizer;
    double stpmax = 100.0;
    private static Logger logger = LoggerFactory.getLogger(VectorizedDeepLearningGradientAscent.class);
    final double eps = 1.0E-10;
    double step = 0.2;

    public VectorizedDeepLearningGradientAscent(OptimizableByGradientValueMatrix function, double initialStepSize) {
        this.optimizable = function;
        this.lineMaximizer = new VectorizedBackTrackLineSearch(function);
        this.lineMaximizer.setAbsTolx(this.tolerance);
    }

    public VectorizedDeepLearningGradientAscent(OptimizableByGradientValueMatrix function, NeuralNetEpochListener listener) {
        this(function, 0.01);
        this.listener = listener;
    }

    public VectorizedDeepLearningGradientAscent(OptimizableByGradientValueMatrix function, double initialStepSize, NeuralNetEpochListener listener) {
        this(function, initialStepSize);
        this.listener = listener;
    }

    public VectorizedDeepLearningGradientAscent(OptimizableByGradientValueMatrix function) {
        this(function, 0.01);
    }

    public OptimizableByGradientValueMatrix getOptimizable() {
        return this.optimizable;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    public VectorizedBackTrackLineSearch getLineMaximizer() {
        return this.lineMaximizer;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getInitialStepSize() {
        return 0.2;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.step = initialStepSize;
    }

    public double getStpmax() {
        return this.stpmax;
    }

    public void setStpmax(double stpmax) {
        this.stpmax = stpmax;
    }

    @Override
    public boolean optimize() {
        return this.optimize(this.maxIterations);
    }

    @Override
    public boolean optimize(int numIterations) {
        double fp = this.optimizable.getValue();
        DoubleMatrix xi = this.optimizable.getValueGradient();
        for (int iterations = 0; iterations < numIterations; ++iterations) {
            logger.info("At iteration " + iterations + ", cost = " + fp + ", scaled = " + this.maxStep + " step = " + this.step + ", gradient infty-norm = " + xi.normmax());
            double sum = xi.norm2();
            if (sum > this.stpmax) {
                logger.info("*** Step 2-norm " + sum + " greater than max " + this.stpmax + "  Scaling...");
                xi.muli(this.stpmax / sum);
            }
            try {
                this.step = this.lineMaximizer.optimize(xi, this.step);
            }
            catch (Exception e) {
                logger.warn("Error during computation", (Throwable)e);
                continue;
            }
            double fret = this.optimizable.getValue();
            if (2.0 * Math.abs(fret - fp) <= this.tolerance * (Math.abs(fret) + Math.abs(fp) + 1.0E-10)) {
                logger.info("Gradient Ascent: Value difference " + Math.abs(fret - fp) + " below " + "tolerance; saying converged.");
                this.converged = true;
                if (this.listener != null) {
                    this.listener.epochDone(iterations);
                }
                return true;
            }
            fp = fret;
            xi = this.optimizable.getValueGradient();
            if (this.listener == null) continue;
            this.listener.epochDone(iterations);
        }
        return false;
    }

    public void setMaxStepSize(double v) {
        this.maxStep = v;
    }
}

