/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.learning;

import java.io.Serializable;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;

public class AdaGrad
implements Serializable {
    private static final long serialVersionUID = -4754127927704099888L;
    private double masterStepSize = 0.001;
    public DoubleMatrix historicalGradient;
    public DoubleMatrix adjustedGradient;
    public double fudgeFactor = 1.0E-6;
    public DoubleMatrix gradient;
    public int rows;
    public int cols;
    private int numIterations = 0;
    private double lrDecay = 0.95;
    private boolean decayLr;
    private double minLearningRate = 1.0E-4;

    public AdaGrad(int rows, int cols, double gamma) {
        this.rows = rows;
        this.cols = cols;
        this.adjustedGradient = new DoubleMatrix(rows, cols);
        this.historicalGradient = new DoubleMatrix(rows, cols);
        this.masterStepSize = gamma;
        this.decayLr = false;
    }

    public AdaGrad(int rows, int cols) {
        this(rows, cols, 0.01);
    }

    public DoubleMatrix getLearningRates(DoubleMatrix gradient) {
        this.gradient = gradient.dup();
        double currentLearningRate = this.masterStepSize;
        if (this.decayLr && this.numIterations > 0) {
            this.masterStepSize *= this.lrDecay;
            if (this.masterStepSize < this.minLearningRate) {
                this.masterStepSize = this.minLearningRate;
            }
        }
        ++this.numIterations;
        this.adjustedGradient = MatrixFunctions.sqrt((DoubleMatrix)MatrixFunctions.pow((DoubleMatrix)this.gradient, (double)2.0)).mul(currentLearningRate);
        this.adjustedGradient.addi(1.0E-6);
        return this.adjustedGradient;
    }

    public double getMasterStepSize() {
        return this.masterStepSize;
    }

    public void setMasterStepSize(double masterStepSize) {
        this.masterStepSize = masterStepSize;
    }

    public synchronized boolean isDecayLr() {
        return this.decayLr;
    }

    public synchronized void setDecayLr(boolean decayLr) {
        this.decayLr = decayLr;
    }
}

