/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.gradient.NeuralNetworkGradientListener;
import org.deeplearning4j.nn.gradient.NeuralNetworkGradient;
import org.deeplearning4j.nn.learning.AdaGrad;
import org.deeplearning4j.optimize.NeuralNetEpochListener;
import org.jblas.DoubleMatrix;

public interface NeuralNetwork
extends Serializable,
Cloneable,
NeuralNetEpochListener {
    public LossFunction getLossFunction();

    public void setLossFunction(LossFunction var1);

    public OptimizationAlgorithm getOptimizationAlgorithm();

    public void setOptimizationAlgorithm(OptimizationAlgorithm var1);

    public boolean normalizeByInputRows();

    public int getnVisible();

    public void setnVisible(int var1);

    public int getnHidden();

    public void setnHidden(int var1);

    public DoubleMatrix getW();

    public void setW(DoubleMatrix var1);

    public DoubleMatrix gethBias();

    public void sethBias(DoubleMatrix var1);

    public DoubleMatrix getvBias();

    public void setvBias(DoubleMatrix var1);

    public RandomGenerator getRng();

    public void setRng(RandomGenerator var1);

    public DoubleMatrix getInput();

    public void setInput(DoubleMatrix var1);

    public double squaredLoss();

    public double negativeLogLikelihood();

    public double getSparsity();

    public void setSparsity(double var1);

    public void setDist(RealDistribution var1);

    public RealDistribution getDist();

    public List<NeuralNetworkGradientListener> getGradientListeners();

    public void setGradientListeners(List<NeuralNetworkGradientListener> var1);

    public DoubleMatrix hBiasMean();

    public AdaGrad getAdaGrad();

    public void setAdaGrad(AdaGrad var1);

    public AdaGrad gethBiasAdaGrad();

    public void setHbiasAdaGrad(AdaGrad var1);

    public AdaGrad getVBiasAdaGrad();

    public void setVBiasAdaGrad(AdaGrad var1);

    public NeuralNetworkGradient getGradient(Object[] var1);

    public double getL2();

    public void setL2(double var1);

    public double getMomentum();

    public void setMomentum(double var1);

    public void setRenderEpochs(int var1);

    public int getRenderEpochs();

    public NeuralNetwork transpose();

    public NeuralNetwork clone();

    public double fanIn();

    public void setFanIn(double var1);

    public Pair<DoubleMatrix, DoubleMatrix> sampleHiddenGivenVisible(DoubleMatrix var1);

    public void setDropOut(double var1);

    public double dropOut();

    public Pair<DoubleMatrix, DoubleMatrix> sampleVisibleGivenHidden(DoubleMatrix var1);

    public void resetAdaGrad(double var1);

    @Override
    public void epochDone(int var1);

    public double l2RegularizedCoefficient();

    public double getReConstructionCrossEntropy();

    public void train(DoubleMatrix var1, double var2, Object[] var4);

    public void trainTillConvergence(DoubleMatrix var1, double var2, Object[] var4);

    public void merge(NeuralNetwork var1, int var2);

    public static enum LossFunction {
        SQUARED_LOSS,
        RECONSTRUCTION_CROSSENTROPY,
        NEGATIVELOGLIKELIHOOD;

    }

    public static enum OptimizationAlgorithm {
        GRADIENT_DESCENT,
        CONJUGATE_GRADIENT;

    }
}

