/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.vectorizer;

import java.io.File;
import org.deeplearning4j.datasets.DataSet;
import org.deeplearning4j.datasets.vectorizer.Vectorizer;
import org.deeplearning4j.util.ImageLoader;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;

public class ImageVectorizer
implements Vectorizer {
    private File image;
    private ImageLoader loader = new ImageLoader();
    private boolean binarize;
    private boolean normalize;
    private int label;
    private int numLabels;
    private int threshold = 30;

    public ImageVectorizer(File image, int numLabels, int label) {
        this.image = image;
        this.numLabels = numLabels;
        this.label = label;
    }

    public ImageVectorizer binarize(int threshold) {
        this.binarize = true;
        this.normalize = false;
        return this;
    }

    public ImageVectorizer binarize() {
        return this.binarize(30);
    }

    public ImageVectorizer normalize() {
        this.binarize = false;
        this.normalize = true;
        return this;
    }

    @Override
    public DataSet vectorize() {
        try {
            DoubleMatrix d = this.loader.asMatrix(this.image);
            DoubleMatrix label2 = MatrixUtil.toOutcomeVector(this.label, this.numLabels);
            if (this.normalize) {
                d = MatrixUtil.normalizeByRowSums(d);
            } else if (this.binarize) {
                for (int i = 0; i < d.length; ++i) {
                    double curr = d.get(i);
                    if (curr > (double)this.threshold) {
                        d.put(i, 1.0);
                        continue;
                    }
                    d.put(i, 0.0);
                }
            }
            return new DataSet(d, label2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

