/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.deeplearning4j.datasets.DataSet;
import org.deeplearning4j.util.ArrayUtil;
import org.deeplearning4j.util.ImageLoader;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFWLoader {
    private File baseDir = new File(System.getProperty("java.io.tmpdir"));
    public static final String LFW = "lfw";
    private File lfwDir = new File(this.baseDir, "lfw");
    public static final String LFW_URL = "http://vis-www.cs.umass.edu/lfw/lfw.tgz";
    private File lfwTarFile = new File(this.lfwDir, "lfw.tgz");
    private static Logger log = LoggerFactory.getLogger(LFWLoader.class);
    private int numNames;
    private int numPixelColumns;
    private ImageLoader loader = new ImageLoader(28, 28);
    private List<String> images = new ArrayList<String>();
    private List<String> outcomes = new ArrayList<String>();

    public LFWLoader() {
        this(28, 28);
    }

    public LFWLoader(int imageWidth, int imageHeight) {
        this.loader = new ImageLoader(imageWidth, imageHeight);
    }

    public void getIfNotExists() throws Exception {
        if (!this.lfwDir.exists()) {
            this.lfwDir.mkdir();
            log.info("Grabbing LFW...");
            URL website = new URL(LFW_URL);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(this.lfwTarFile);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.flush();
            fos.close();
            rbc.close();
            log.info("Downloaded lfw");
            this.untarFile(this.baseDir, this.lfwTarFile);
        }
        File firstImage = null;
        try {
            firstImage = this.lfwDir.listFiles()[0].listFiles()[0];
        }
        catch (Exception e) {
            FileUtils.deleteDirectory((File)this.lfwDir);
            this.getIfNotExists();
            log.warn("Error opening first image; probably corrupt download...trying again");
        }
        this.numPixelColumns = ArrayUtil.flatten(this.loader.fromFile(firstImage)).length;
        this.numNames = this.lfwDir.getAbsoluteFile().listFiles().length;
        Collection allImages = FileUtils.listFiles((File)this.lfwDir, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File f : allImages) {
            this.images.add(f.getAbsolutePath());
        }
        for (File dir : this.lfwDir.getAbsoluteFile().listFiles()) {
            this.outcomes.add(dir.getAbsolutePath());
        }
    }

    public DataSet convertListPairs(List<DataSet> images) {
        DoubleMatrix inputs = new DoubleMatrix(images.size(), this.numPixelColumns);
        DoubleMatrix outputs = new DoubleMatrix(images.size(), this.numNames);
        for (int i = 0; i < images.size(); ++i) {
            inputs.putRow(i, (DoubleMatrix)images.get(i).getFirst());
            outputs.putRow(i, (DoubleMatrix)images.get(i).getSecond());
        }
        return new DataSet(inputs, outputs);
    }

    public DataSet getDataFor(int i) {
        File image = new File(this.images.get(i));
        int outcome = this.outcomes.indexOf(image.getParentFile().getAbsolutePath());
        try {
            return new DataSet(this.loader.asRowVector(image), MatrixUtil.toOutcomeVector(outcome, this.outcomes.size()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get data for image " + i + " for path " + this.images.get(i));
        }
    }

    public List<DataSet> getFirst(int num) throws Exception {
        ArrayList<DataSet> ret = new ArrayList<DataSet>(num);
        File[] files = this.lfwDir.listFiles();
        int label = 0;
        for (File file : files) {
            ret.addAll(this.getImages(label, file));
            ++label;
            if (ret.size() >= num) break;
        }
        return ret;
    }

    public DataSet getAllImagesAsMatrix() throws Exception {
        List<DataSet> images = this.getImagesAsList();
        return this.convertListPairs(images);
    }

    public DataSet getAllImagesAsMatrix(int numRows) throws Exception {
        List<DataSet> images = this.getImagesAsList().subList(0, numRows);
        return this.convertListPairs(images);
    }

    public List<DataSet> getImagesAsList() throws Exception {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        File[] dirs = this.lfwDir.listFiles();
        for (int i = 0; i < dirs.length; ++i) {
            list.addAll(this.getImages(i, dirs[i]));
        }
        return list;
    }

    public List<DataSet> getImages(int label, File file) throws Exception {
        File[] images = file.listFiles();
        ArrayList<DataSet> ret = new ArrayList<DataSet>();
        for (File f : images) {
            ret.add(this.fromImageFile(label, f));
        }
        return ret;
    }

    public DataSet fromImageFile(int label, File image) throws Exception {
        DoubleMatrix outcome = MatrixUtil.toOutcomeVector(label, this.numNames);
        DoubleMatrix image2 = MatrixUtil.toMatrix(this.loader.flattenedImageFromFile(image));
        return new DataSet(image2, outcome);
    }

    public void untarFile(File baseDir, File tarFile) throws IOException {
        log.info("Untaring File: " + tarFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("tar -C %s -xvf %s", baseDir.getAbsolutePath(), tarFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
    }

    public static void gunzipFile(File baseDir, File gzFile) throws IOException {
        String s;
        log.info("gunzip'ing File: " + gzFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("gunzip %s", gzFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public int getNumNames() {
        return this.numNames;
    }

    public int getNumPixelColumns() {
        return this.numPixelColumns;
    }
}

