/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets;

public class NN {
    int numnodes;
    int maxedges;
    float[] currentState;
    float[] nextState;
    int[][] edges;
    float[][] weights;
    int[] inputNodes = null;
    float[] inputValues;
    int[] outputNodes = null;
    float[] outputValues;
    boolean firstUpdate = true;

    public NN(int nodes, int maxedges) {
        this.numnodes = nodes;
        this.maxedges = maxedges;
        this.currentState = new float[nodes];
        this.nextState = new float[nodes];
        this.edges = new int[nodes][maxedges];
        this.weights = new float[nodes][maxedges];
    }

    public void init() {
        for (int i = 0; i < this.numnodes; ++i) {
            int j;
            for (j = 0; j < this.maxedges; ++j) {
                this.edges[i][j] = -1;
            }
            int numedges = (int)(Math.random() * (double)(this.maxedges + 1));
            for (j = 0; j < numedges; ++j) {
                int node;
                this.edges[i][j] = node = this.getRandomPartner(i, false);
                this.weights[i][j] = (float)Math.random();
            }
        }
    }

    public void setInput(int[] inputNodes, float[] inputValues) {
        this.inputNodes = inputNodes;
        this.inputValues = inputValues;
        this.applyInput();
        this.firstUpdate = true;
    }

    public void setOutput(int[] outputNodes, float[] outputValues) {
        this.outputNodes = outputNodes;
        this.outputValues = outputValues;
        this.applyOutput();
        this.firstUpdate = true;
    }

    private void applyInput() {
        for (int i = 0; i < this.inputNodes.length; ++i) {
            this.currentState[this.inputNodes[i]] = this.inputValues[i];
        }
    }

    private void applyOutput() {
        for (int i = 0; i < this.outputNodes.length; ++i) {
            this.currentState[this.outputNodes[i]] = this.outputValues[i];
        }
    }

    public void update() {
        int i;
        if (this.firstUpdate) {
            this.firstUpdate = false;
        } else {
            if (this.inputNodes != null) {
                this.applyInput();
            }
            if (this.outputNodes != null) {
                this.applyOutput();
            }
        }
        double threashold = 0.9;
        double theta = 1.0;
        for (i = 0; i < this.numnodes; ++i) {
            boolean active;
            double x = this.currentState[i];
            double sigmoid = 1.0 / Math.pow(Math.E, -x) - theta;
            boolean bl = active = sigmoid > threashold;
            if (!active) continue;
            for (int j = 0; j < this.maxedges && this.edges[i][j] != -1; ++j) {
                int n = this.edges[i][j];
                this.nextState[n] = this.nextState[n] + this.weights[i][j] * this.currentState[i];
            }
        }
        for (i = 0; i < this.numnodes; ++i) {
            this.currentState[i] = this.nextState[i];
            this.nextState[i] = 0.0f;
        }
    }

    public void reset() {
        for (int i = 0; i < this.numnodes; ++i) {
            this.currentState[i] = 0.0f;
        }
    }

    public float[] getState() {
        return this.currentState;
    }

    public float[] readOutput() {
        if (this.outputNodes == null) {
            return null;
        }
        float[] values = new float[this.outputNodes.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.currentState[this.outputNodes[i]];
        }
        return values;
    }

    public float[] readInput() {
        float[] values = null;
        if (this.inputNodes != null) {
            values = new float[this.inputNodes.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.currentState[this.inputNodes[i]];
            }
        }
        return values;
    }

    private int getRandomPartner(int self, boolean selfAllowed) {
        int node = (int)(Math.random() * (double)this.numnodes);
        if (!selfAllowed) {
            while (node == self) {
                node = (int)(Math.random() * (double)this.numnodes);
            }
        }
        return node;
    }

    public String toString() {
        String s = "Network statistics:\n";
        s = s + "Total nodes: " + this.numnodes + "\n";
        int numedges = 0;
        for (int i = 0; i < this.numnodes; ++i) {
            for (int j = 0; j < this.maxedges && this.edges[i][j] != -1; ++j) {
                ++numedges;
            }
            s = s + "";
        }
        s = s + "Total edges: " + numedges + "\n";
        s = s + "Edge density: " + (float)numedges / (float)this.numnodes + "\n";
        s = s + "Occupancy: " + (float)numedges / (float)(this.maxedges * this.numnodes) + "\n";
        return s;
    }

    public String getConnections() {
        String s = "Connections:\n";
        for (int i = 0; i < this.numnodes; ++i) {
            s = s + i + ": ";
            for (int j = 0; j < this.maxedges; ++j) {
                if (this.edges[i][j] == -1) continue;
                s = s + this.edges[i][j] + ",";
            }
            s = s + "\n";
        }
        return s;
    }

    public String getWeights() {
        String s = "Weights:\n";
        for (int i = 0; i < this.numnodes; ++i) {
            s = s + i + ": ";
            for (int j = 0; j < this.maxedges; ++j) {
                if (this.edges[i][j] == -1) continue;
                s = s + this.weights[i][j] + ",";
            }
            s = s + "\n";
        }
        return s;
    }

    public String getCurrentState() {
        String s = "Current State:\n";
        for (int i = 0; i < this.numnodes; ++i) {
            s = s + i + ": ";
            s = s + this.currentState[i] + "\n";
        }
        return s;
    }

    public String getNextState() {
        String s = "Next State:\n";
        for (int i = 0; i < this.numnodes; ++i) {
            s = s + i + ": ";
            s = s + this.nextState[i] + "\n";
        }
        return s;
    }

    public static void main(String[] args) {
        NN net = new NN(10, 5);
        net.init();
        net.setInput(new int[]{0, 1, 2, 3, 4}, new float[]{1.0f, 0.5f, 0.2f, 0.9f, 0.7f});
        System.out.println(net.getConnections());
        System.out.println(net.getWeights());
        while (true) {
            System.out.println(net.getCurrentState());
            net.update();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

