/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.util.ArrayUtil;
import org.deeplearning4j.util.ImageLoader;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFWLoader {
    private File baseDir = new File(System.getProperty("java.io.tmpdir"));
    public static final String LFW = "lfw";
    private File lfwDir = new File(this.baseDir, "lfw");
    public static final String LFW_URL = "http://vis-www.cs.umass.edu/lfw/lfw.tgz";
    private File lfwTarFile = new File(this.lfwDir, "lfw.tgz");
    private static Logger log = LoggerFactory.getLogger(LFWLoader.class);
    private int numNames;
    private int numPixelColumns;
    private ImageLoader loader = new ImageLoader();
    private List<String> images = new ArrayList<String>();
    private List<String> outcomes = new ArrayList<String>();

    public void getIfNotExists() throws Exception {
        if (!this.lfwDir.exists()) {
            this.lfwDir.mkdir();
            FileUtils.copyURLToFile((URL)new URL(LFW_URL), (File)this.lfwTarFile);
            this.untarFile(this.baseDir, this.lfwTarFile);
        }
        File firstImage = this.lfwDir.listFiles()[0].listFiles()[0];
        this.numPixelColumns = ArrayUtil.flatten(this.loader.fromFile(firstImage)).length;
        this.numNames = this.lfwDir.getAbsoluteFile().listFiles().length;
        Collection allImages = FileUtils.listFiles((File)this.lfwDir, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File f : allImages) {
            this.images.add(f.getAbsolutePath());
        }
        for (File dir : this.lfwDir.getAbsoluteFile().listFiles()) {
            this.outcomes.add(dir.getAbsolutePath());
        }
    }

    public Pair<DoubleMatrix, DoubleMatrix> convertListPairs(List<Pair<DoubleMatrix, DoubleMatrix>> images) {
        DoubleMatrix inputs = new DoubleMatrix(images.size(), this.numPixelColumns);
        DoubleMatrix outputs = new DoubleMatrix(images.size(), this.numNames);
        for (int i = 0; i < images.size(); ++i) {
            inputs.putRow(i, images.get(i).getFirst());
            outputs.putRow(i, images.get(i).getSecond());
        }
        return new Pair<DoubleMatrix, DoubleMatrix>(inputs, outputs);
    }

    public Pair<DoubleMatrix, DoubleMatrix> getDataFor(int i) {
        File image = new File(this.images.get(i));
        int outcome = this.outcomes.indexOf(image.getParentFile().getAbsolutePath());
        try {
            return new Pair<DoubleMatrix, DoubleMatrix>(this.loader.asRowVector(image), MatrixUtil.toOutcomeVector(outcome, this.outcomes.size()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get data for image " + i + " for path " + this.images.get(i));
        }
    }

    public List<Pair<DoubleMatrix, DoubleMatrix>> getFirst(int num) throws Exception {
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> ret = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>(num);
        File[] files = this.lfwDir.listFiles();
        int label = 0;
        for (File file : files) {
            ret.addAll(this.getImages(label, file));
            ++label;
            if (ret.size() >= num) break;
        }
        return ret;
    }

    public Pair<DoubleMatrix, DoubleMatrix> getAllImagesAsMatrix() throws Exception {
        List<Pair<DoubleMatrix, DoubleMatrix>> images = this.getImagesAsList();
        return this.convertListPairs(images);
    }

    public Pair<DoubleMatrix, DoubleMatrix> getAllImagesAsMatrix(int numRows) throws Exception {
        List<Pair<DoubleMatrix, DoubleMatrix>> images = this.getImagesAsList().subList(0, numRows);
        return this.convertListPairs(images);
    }

    public List<Pair<DoubleMatrix, DoubleMatrix>> getImagesAsList() throws Exception {
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> list = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>();
        File[] dirs = this.lfwDir.listFiles();
        for (int i = 0; i < dirs.length; ++i) {
            list.addAll(this.getImages(i, dirs[i]));
        }
        return list;
    }

    public List<Pair<DoubleMatrix, DoubleMatrix>> getImages(int label, File file) throws Exception {
        File[] images = file.listFiles();
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> ret = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>();
        for (File f : images) {
            ret.add(this.fromImageFile(label, f));
        }
        return ret;
    }

    public Pair<DoubleMatrix, DoubleMatrix> fromImageFile(int label, File image) throws Exception {
        DoubleMatrix outcome = MatrixUtil.toOutcomeVector(label, this.numNames);
        DoubleMatrix image2 = MatrixUtil.toMatrix(this.loader.flattenedImageFromFile(image));
        return new Pair<DoubleMatrix, DoubleMatrix>(image2, outcome);
    }

    public void untarFile(File baseDir, File tarFile) throws IOException {
        String s;
        log.info("Untaring File: " + tarFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("tar -C %s -xvf %s", baseDir.getAbsolutePath(), tarFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public static void gunzipFile(File baseDir, File gzFile) throws IOException {
        String s;
        log.info("gunzip'ing File: " + gzFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("gunzip %s", gzFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public int getNumNames() {
        return this.numNames;
    }

    public int getNumPixelColumns() {
        return this.numPixelColumns;
    }
}

