/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.activation;

import org.deeplearning4j.nn.activation.ActivationFunction;
import org.jblas.DoubleMatrix;

public class HardTanh
implements ActivationFunction {
    private static final long serialVersionUID = -8484119406683594852L;

    public DoubleMatrix apply(DoubleMatrix matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            double val = matrix.get(i);
            val = val < -1.0 ? -1.0 : (val > 1.0 ? 1.0 : Math.tanh(val));
            matrix.put(i, val);
        }
        return matrix;
    }

    @Override
    public DoubleMatrix applyDerivative(DoubleMatrix input) {
        for (int i = 0; i < input.length; ++i) {
            double val = input.get(i);
            val = val < -1.0 ? -1.0 : (val > 1.0 ? 1.0 : 1.0 - Math.pow(Math.tanh(val), 2.0));
            input.put(i, val);
        }
        return input;
    }
}

