/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.mnist.draw;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.jblas.DoubleMatrix;

public class DrawMnistGreyScale {
    public JFrame frame;
    BufferedImage img = new BufferedImage(this.width, this.height, 1);
    private int width = 28;
    private int height = 28;
    public String title = "TEST";
    private int heightOffset = 0;
    private int widthOffset = 0;

    public DrawMnistGreyScale(DoubleMatrix data, int heightOffset, int widthOffset) {
        this.heightOffset = heightOffset;
        this.widthOffset = widthOffset;
        WritableRaster r = this.img.getRaster();
        int[] equiv = new int[data.length];
        for (int i = 0; i < equiv.length; ++i) {
            equiv[i] = (int)Math.round(data.get(i));
        }
        r.setDataElements(0, 0, this.width, this.height, equiv);
    }

    public DrawMnistGreyScale(DoubleMatrix data) {
        WritableRaster r = this.img.getRaster();
        int[] equiv = new int[data.length];
        for (int i = 0; i < equiv.length; ++i) {
            equiv[i] = (int)Math.round(data.get(i));
        }
        r.setDataElements(0, 0, this.width, this.height, equiv);
    }

    public void draw() {
        this.frame = new JFrame(this.title);
        this.frame.setVisible(true);
        this.start();
        this.frame.add(new JLabel(new ImageIcon(this.getImage())));
        this.frame.pack();
        this.frame.setDefaultCloseOperation(2);
    }

    public void close() {
        this.frame.dispose();
    }

    public Image getImage() {
        return this.img;
    }

    public void start() {
        int[] pixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        boolean running = true;
        while (running) {
            BufferStrategy bs = this.frame.getBufferStrategy();
            if (bs == null) {
                this.frame.createBufferStrategy(4);
                return;
            }
            for (int i = 0; i < this.width * this.height; ++i) {
                pixels[i] = 0;
            }
            Graphics g = bs.getDrawGraphics();
            g.drawImage(this.img, this.heightOffset, this.widthOffset, this.width, this.height, null);
            g.dispose();
            bs.show();
        }
    }
}

