/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.deeplearning4j.datasets.DataSet;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.jblas.DoubleMatrix;

public class ListDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -7569201667767185411L;
    private int curr = 0;
    private int batch = 10;
    private List<DataSet> list;

    public ListDataSetIterator(Collection<DataSet> coll, int batch) {
        this.list = new ArrayList<DataSet>(coll);
        this.batch = batch;
    }

    public ListDataSetIterator(Collection<DataSet> coll) {
        this(coll, 5);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.curr < this.list.size();
    }

    @Override
    public synchronized DataSet next() {
        int range = this.curr + this.batch;
        if (range >= this.list.size()) {
            range = this.list.size();
        }
        DataSet d = DataSet.merge(this.list.subList(this.curr, range));
        this.curr += this.batch;
        return d;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalExamples() {
        return this.list.size();
    }

    @Override
    public int inputColumns() {
        return ((DoubleMatrix)this.list.get((int)0).getFirst()).columns;
    }

    @Override
    public int totalOutcomes() {
        return ((DoubleMatrix)this.list.get((int)0).getSecond()).columns;
    }

    @Override
    public synchronized void reset() {
        this.curr = 0;
    }

    @Override
    public int batch() {
        return this.batch;
    }

    @Override
    public synchronized int cursor() {
        return this.curr;
    }

    @Override
    public int numExamples() {
        return this.list.size();
    }
}

