/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.base.IrisUtils;
import org.deeplearning4j.base.LFWLoader;
import org.deeplearning4j.base.MnistFetcher;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.datasets.MnistManager;
import org.deeplearning4j.util.ArrayUtil;
import org.deeplearning4j.util.MathUtils;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeepLearningTest {
    private static Logger log = LoggerFactory.getLogger(DeepLearningTest.class);

    public static Pair<DoubleMatrix, DoubleMatrix> getIris() throws IOException {
        Pair<DoubleMatrix, DoubleMatrix> pair = IrisUtils.loadIris();
        return pair;
    }

    public static Pair<DoubleMatrix, DoubleMatrix> getIris(int num) throws IOException {
        Pair<DoubleMatrix, DoubleMatrix> pair = IrisUtils.loadIris(num);
        return pair;
    }

    public static Pair<DoubleMatrix, DoubleMatrix> getFaces(int num) throws Exception {
        LFWLoader loader = new LFWLoader();
        loader.getIfNotExists();
        return loader.getAllImagesAsMatrix(num);
    }

    public static Pair<DoubleMatrix, DoubleMatrix> getFacesMatrix() throws Exception {
        LFWLoader loader = new LFWLoader();
        loader.getIfNotExists();
        return loader.getAllImagesAsMatrix();
    }

    public static List<Pair<DoubleMatrix, DoubleMatrix>> getFirstFaces(int num) throws Exception {
        LFWLoader loader = new LFWLoader();
        loader.getIfNotExists();
        return loader.getFirst(num);
    }

    public List<Pair<DoubleMatrix, DoubleMatrix>> getFaces() throws Exception {
        LFWLoader loader = new LFWLoader();
        loader.getIfNotExists();
        return loader.getImagesAsList();
    }

    public static Pair<DoubleMatrix, DoubleMatrix> getMnistExample(int example) throws IOException {
        File ensureExists = new File("/tmp/MNIST");
        if (!ensureExists.exists()) {
            new MnistFetcher().downloadAndUntar();
        }
        MnistManager man = new MnistManager("/tmp/MNIST/train-images-idx1-ubyte", "/tmp/MNIST/train-labels-idx1-ubyte");
        man.setCurrent(example);
        int[] imageExample = ArrayUtil.flatten(man.readImage());
        return new Pair<DoubleMatrix, DoubleMatrix>(MatrixUtil.toMatrix(imageExample).transpose(), MatrixUtil.toOutcomeVector(man.readLabel(), 10));
    }

    public List<Pair<DoubleMatrix, DoubleMatrix>> getMnistExampleBatches(int batchSize, int numBatches) throws IOException {
        File ensureExists = new File("/tmp/MNIST");
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> ret = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>();
        if (!ensureExists.exists()) {
            new MnistFetcher().downloadAndUntar();
        }
        MnistManager man = new MnistManager("/tmp/MNIST/train-images-idx1-ubyte", "/tmp/MNIST/train-labels-idx1-ubyte");
        int[][] image = man.readImage();
        int[] imageExample = ArrayUtil.flatten(image);
        for (int batch = 0; batch < numBatches; ++batch) {
            double[][] examples = new double[batchSize][imageExample.length];
            int[][] outcomeMatrix = new int[batchSize][10];
            for (int i = 1 + batch; i < batchSize + 1 + batch; ++i) {
                man.setCurrent(i);
                double[] currExample = ArrayUtil.flatten(ArrayUtil.toDouble(man.readImage()));
                examples[i - 1 - batch] = currExample;
                outcomeMatrix[i - 1 - batch] = ArrayUtil.toOutcomeArray(man.readLabel(), 10);
            }
            DoubleMatrix training = new DoubleMatrix(examples);
            ret.add(new Pair<DoubleMatrix, DoubleMatrix>(training, MatrixUtil.toMatrix(outcomeMatrix)));
        }
        return ret;
    }

    public static Pair<DoubleMatrix, DoubleMatrix> getMnistExampleBatch(int batchSize) throws IOException {
        File ensureExists = new File("/tmp/MNIST");
        if (!(ensureExists.exists() && new File("/tmp/MNIST/train-images-idx1-ubyte").exists() && new File("/tmp/MNIST/train-labels-idx1-ubyte").exists())) {
            new MnistFetcher().downloadAndUntar();
        }
        MnistManager man = new MnistManager("/tmp/MNIST/train-images-idx1-ubyte", "/tmp/MNIST/train-labels-idx1-ubyte");
        int[][] image = man.readImage();
        int[] imageExample = ArrayUtil.flatten(image);
        double[][] examples = new double[batchSize][imageExample.length];
        int[][] outcomeMatrix = new int[batchSize][10];
        for (int i = 1; i < batchSize + 1; ++i) {
            man.setCurrent(i);
            double[] currExample = ArrayUtil.flatten(ArrayUtil.toDouble(man.readImage()));
            for (int j = 0; j < currExample.length; ++j) {
                currExample[j] = MathUtils.normalize(currExample[j], 0.0, 255.0);
            }
            examples[i - 1] = currExample;
            outcomeMatrix[i - 1] = ArrayUtil.toOutcomeArray(man.readLabel(), 10);
        }
        DoubleMatrix training = new DoubleMatrix(examples);
        return new Pair<DoubleMatrix, DoubleMatrix>(training, MatrixUtil.toMatrix(outcomeMatrix));
    }
}

