/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.forward.standard;

import deepboof.Tensor;
import deepboof.forward.ConfigSpatial;
import deepboof.forward.SpatialPadding2D;
import deepboof.impl.forward.standard.BaseFunction;

public abstract class BaseSpatialWindow<T extends Tensor<T>, P extends SpatialPadding2D<T>>
extends BaseFunction<T> {
    protected ConfigSpatial config;
    protected int N;
    protected int C;
    protected int H;
    protected int W;
    protected int HH;
    protected int WW;
    protected int Ho;
    protected int Wo;
    protected int Hp;
    protected int Wp;
    protected P padding;

    public BaseSpatialWindow(ConfigSpatial config, P padding) {
        this.config = config;
        this.padding = padding;
    }

    @Override
    public void _initialize() {
        if (this.shapeInput.length != 3) {
            throw new IllegalArgumentException("Expected 3D spatial tensor");
        }
        this.C = this.shapeInput[0];
        this.H = this.shapeInput[1];
        this.W = this.shapeInput[2];
        this.WW = this.config.WW;
        this.HH = this.config.HH;
        int[] paddedShape = this.padding.shapeGivenInput(this.shapeInput);
        this.Hp = paddedShape[1];
        this.Wp = paddedShape[2];
        if (this.WW > this.Wp) {
            throw new IllegalArgumentException("Window size is bigger then padded tensor's width");
        }
        if (this.HH > this.Hp) {
            throw new IllegalArgumentException("Window size is bigger then padded tensor's height");
        }
        this.Ho = 1 + (this.Hp - this.HH) / this.config.periodY;
        this.Wo = 1 + (this.Wp - this.WW) / this.config.periodX;
        if (this.Ho <= 0) {
            throw new IllegalArgumentException("As configured output height is <= 0");
        }
        if (this.Wo <= 0) {
            throw new IllegalArgumentException("As configured output width is <= 0");
        }
        this.shapeOutput = new int[]{this.C, this.Ho, this.Wo};
    }

    protected boolean isEntirelyBorder(int outR0, int outC0) {
        if (outC0 >= this.Wo || outR0 >= this.Ho) {
            return true;
        }
        int padR0 = this.padding.getPaddingRow0();
        int padC0 = this.padding.getPaddingCol0();
        return outC0 * this.config.periodX + this.WW > this.W + padC0 || outR0 * this.config.periodY + this.HH > this.H + padR0;
    }

    public static int innerLowerExtent(int period, int padding) {
        return (int)Math.ceil((double)padding / (double)period);
    }

    public static int innerUpperExtent(int windowLength, int period, int padding, int inputLength) {
        return (inputLength + padding - windowLength) / period;
    }

    public P getPadding() {
        return this.padding;
    }
}

