/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7.struct;

import deepboof.io.torch7.struct.TorchStorage;

public class TorchFloatStorage
extends TorchStorage {
    public float[] data;

    public TorchFloatStorage(int size) {
        this.data = new float[size];
        this.torchName = "torch.FloatStorage";
    }

    @Override
    public Object getDataObject() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public void printSummary() {
        System.out.println("    storage length = " + this.size());
        if (this.size() >= 4) {
            int i;
            int w = Math.min(3, this.size() / 2 - 1);
            for (i = 0; i < w; ++i) {
                System.out.println("[ " + i + " ] " + this.data[i]);
            }
            System.out.println("....");
            for (i = 0; i < w; ++i) {
                int n = this.size() - w + i;
                System.out.println("[ " + n + " ] " + this.data[n]);
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                System.out.println("[ " + i + " ] " + this.data[i]);
            }
        }
    }
}

