/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.twowaysql.context.CommandContext;
import org.dbflute.twowaysql.exception.ForCommentIllegalParameterBeanSpecificationException;
import org.dbflute.twowaysql.exception.ForCommentParameterNotListException;
import org.dbflute.twowaysql.factory.NodeAdviceFactory;
import org.dbflute.twowaysql.node.BoundValue;
import org.dbflute.twowaysql.node.BoundValueTracer;
import org.dbflute.twowaysql.node.LoopAbstractNode;
import org.dbflute.twowaysql.node.LoopAcceptable;
import org.dbflute.twowaysql.node.LoopFirstNode;
import org.dbflute.twowaysql.node.LoopInfo;
import org.dbflute.twowaysql.node.LoopLastNode;
import org.dbflute.twowaysql.node.LoopNextNode;
import org.dbflute.twowaysql.node.NodeChecker;
import org.dbflute.twowaysql.node.ParameterCommentType;
import org.dbflute.twowaysql.node.ScopeNode;
import org.dbflute.twowaysql.node.SqlConnectorAdjustable;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class ForNode
extends ScopeNode
implements SqlConnectorAdjustable,
LoopAcceptable {
    public static final String PREFIX = "FOR ";
    public static final String CURRENT_VARIABLE = "#current";
    protected final String _expression;
    protected final List<String> _nameList;
    protected final String _specifiedSql;
    protected final NodeAdviceFactory _nodeAdviceFactory;

    public ForNode(String expression, String specifiedSql, NodeAdviceFactory nodeAdviceFactory) {
        this._expression = expression;
        this._nameList = Srl.splitList(expression, ".");
        this._specifiedSql = specifiedSql;
        this._nodeAdviceFactory = nodeAdviceFactory;
    }

    @Override
    public void accept(CommandContext ctx) {
        this.doAccept(ctx, null);
    }

    @Override
    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        if (firstName.equals(CURRENT_VARIABLE)) {
            Object parameter = loopInfo.getCurrentParameter();
            Class<?> parameterType = loopInfo.getCurrentParameterType();
            this.doAccept(ctx, parameter, parameterType, loopInfo, true);
        } else {
            this.doAccept(ctx, loopInfo);
        }
    }

    public void doAccept(CommandContext ctx, LoopInfo parentLoop) {
        String firstName = this._nameList.get(0);
        this.assertFirstNameAsNormal(ctx, firstName);
        Object value = ctx.getArg(firstName);
        Class<?> clazz = ctx.getArgType(firstName);
        this.doAccept(ctx, value, clazz, parentLoop, false);
    }

    public void doAccept(CommandContext ctx, Object firstValue, Class<?> firstType, LoopInfo parentLoop, boolean inheritLoop) {
        Object targetValue;
        if (firstValue == null) {
            return;
        }
        BoundValue boundValue = new BoundValue();
        boundValue.setFirstValue(firstValue);
        boundValue.setFirstType(firstType);
        this.setupBoundValue(boundValue);
        if (inheritLoop) {
            boundValue.inheritLikeSearchOptionIfNeeds(parentLoop);
        }
        if ((targetValue = boundValue.getTargetValue()) == null) {
            return;
        }
        this.assertParameterList(targetValue);
        List parameterList = (List)targetValue;
        int loopSize = parameterList.size();
        LoopInfo loopInfo = new LoopInfo();
        loopInfo.setParentLoop(parentLoop);
        loopInfo.setExpression(this._expression);
        loopInfo.setSpecifiedSql(this._specifiedSql);
        loopInfo.setParameterList(parameterList);
        loopInfo.setLoopSize(loopSize);
        loopInfo.setFilteringBindOption(boundValue.getFilteringBindOption());
        for (int loopIndex = 0; loopIndex < loopSize; ++loopIndex) {
            loopInfo.setLoopIndex(loopIndex);
            this.processAcceptingChildren(ctx, loopInfo);
        }
        if (loopSize > 0) {
            ctx.setEnabled(true);
        }
    }

    protected void assertFirstNameAsNormal(CommandContext ctx, String firstName) {
        if (NodeChecker.isCurrentVariableOutOfScope(firstName, false)) {
            this.throwLoopCurrentVariableOutOfForCommentException();
        }
        if (NodeChecker.isWrongParameterBeanName(firstName, ctx)) {
            this.throwForCommentIllegalParameterBeanSpecificationException();
        }
    }

    protected void throwLoopCurrentVariableOutOfForCommentException() {
        NodeChecker.throwLoopCurrentVariableOutOfForCommentException(this._expression, this._specifiedSql);
    }

    protected void throwForCommentIllegalParameterBeanSpecificationException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The FOR comment had the illegal parameter-bean specification!");
        br.addItem("Advice");
        br.addElement("Please confirm your FOR comment.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    /*FOR pmb,memberId*/");
        br.addElement("    /*FOR p mb,memberId*/");
        br.addElement("    /*FOR pmb:memberId*/");
        br.addElement("    /*FOR pmb,memberId*/");
        br.addElement("  (o):");
        br.addElement("    /*FOR pmb.memberId*/");
        br.addItem("FOR Comment Expression");
        br.addElement(this._expression);
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new ForCommentIllegalParameterBeanSpecificationException(msg);
    }

    protected void setupBoundValue(BoundValue boundValue) {
        ParameterCommentType type = ParameterCommentType.FORCOMMENT;
        BoundValueTracer tracer = this.createBoundValueTracer(type);
        tracer.trace(boundValue);
    }

    protected BoundValueTracer createBoundValueTracer(ParameterCommentType type) {
        return this._nodeAdviceFactory.createBoundValueTracer(this._nameList, this._expression, this._specifiedSql, type);
    }

    protected void assertParameterList(Object targetValue) {
        if (!List.class.isInstance(targetValue)) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The parameter for FOR coment was not list.");
            br.addItem("FOR Comment Expression");
            br.addElement(this._expression);
            br.addItem("Parameter");
            br.addElement(targetValue.getClass());
            br.addElement(targetValue);
            br.addItem("Specified SQL");
            br.addElement(this._specifiedSql);
            String msg = br.buildExceptionMessage();
            throw new ForCommentParameterNotListException(msg);
        }
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._expression + "}";
    }

    public String getExpression() {
        return this._expression;
    }

    public static interface LoopVariableNodeFactory {
        public LoopAbstractNode create(String var1, String var2);
    }

    public static enum LoopVariableType {
        FIRST("first", new LoopVariableNodeFactory(){

            @Override
            public LoopAbstractNode create(String expression, String specifiedSql) {
                return new LoopFirstNode(expression, specifiedSql);
            }
        }),
        NEXT("next", new LoopVariableNodeFactory(){

            @Override
            public LoopAbstractNode create(String expression, String specifiedSql) {
                return new LoopNextNode(expression, specifiedSql);
            }
        }),
        LAST("last", new LoopVariableNodeFactory(){

            @Override
            public LoopAbstractNode create(String expression, String specifiedSql) {
                return new LoopLastNode(expression, specifiedSql);
            }
        });

        private static final Map<String, LoopVariableType> _codeValueMap;
        private String _code;
        private LoopVariableNodeFactory _factory;

        private LoopVariableType(String code, LoopVariableNodeFactory factory) {
            this._code = code;
            this._factory = factory;
        }

        public String code() {
            return this._code;
        }

        public static LoopVariableType codeOf(Object code) {
            if (code == null) {
                return null;
            }
            if (code instanceof LoopVariableType) {
                return (LoopVariableType)((Object)code);
            }
            return _codeValueMap.get(code.toString().toLowerCase());
        }

        public LoopAbstractNode createNode(String expression, String specifiedSql) {
            return this._factory.create(expression, specifiedSql);
        }

        static {
            _codeValueMap = new HashMap<String, LoopVariableType>();
            for (LoopVariableType value : LoopVariableType.values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }
    }
}

