/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql.node;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.exception.DfBeanIllegalPropertyException;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.twowaysql.exception.BindVariableCommentListIndexNotNumberException;
import org.dbflute.twowaysql.exception.BindVariableCommentListIndexOutOfBoundsException;
import org.dbflute.twowaysql.exception.BindVariableCommentNotFoundPropertyException;
import org.dbflute.twowaysql.exception.BindVariableCommentPropertyReadFailureException;
import org.dbflute.twowaysql.exception.EmbeddedVariableCommentListIndexNotNumberException;
import org.dbflute.twowaysql.exception.EmbeddedVariableCommentListIndexOutOfBoundsException;
import org.dbflute.twowaysql.exception.EmbeddedVariableCommentNotFoundPropertyException;
import org.dbflute.twowaysql.exception.EmbeddedVariableCommentPropertyReadFailureException;
import org.dbflute.twowaysql.exception.ForCommentListIndexNotNumberException;
import org.dbflute.twowaysql.exception.ForCommentListIndexOutOfBoundsException;
import org.dbflute.twowaysql.exception.ForCommentNotFoundPropertyException;
import org.dbflute.twowaysql.exception.ForCommentPropertyReadFailureException;
import org.dbflute.twowaysql.node.BoundValue;
import org.dbflute.twowaysql.node.FilteringBindOption;
import org.dbflute.twowaysql.node.ParameterCommentType;
import org.dbflute.twowaysql.pmbean.MapParameterBean;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class BoundValueTracer {
    protected static final String LIKE_SEARCH_OPTION_SUFFIX = "InternalLikeSearchOption";
    protected final List<String> _nameList;
    protected final String _expression;
    protected final String _specifiedSql;
    protected final ParameterCommentType _commentType;

    public BoundValueTracer(List<String> nameList, String expression, String specifiedSql, ParameterCommentType commentType) {
        this._nameList = nameList;
        this._expression = expression;
        this._specifiedSql = specifiedSql;
        this._commentType = commentType;
    }

    public void trace(BoundValue boundValue) {
        Object value = boundValue.getFirstValue();
        if (value == null) {
            return;
        }
        Class<?> clazz = boundValue.getFirstType();
        FilteringBindOption filteringBindOption = null;
        for (int pos = 1; pos < this._nameList.size() && value != null; ++pos) {
            Map map;
            FilteringBindOption currentOption;
            String currentName = this._nameList.get(pos);
            DfBeanDesc beanDesc = this.getBeanDesc(clazz);
            if (this.hasLikeSearchProperty(beanDesc, currentName, value) && (currentOption = this.getFilteringBindOption(beanDesc, currentName, value)) != null) {
                filteringBindOption = currentOption;
            }
            if (beanDesc.hasPropertyDesc(currentName)) {
                DfPropertyDesc pd = beanDesc.getPropertyDesc(currentName);
                clazz = (value = this.getPropertyValue(clazz, value, currentName, pd)) != null ? value.getClass() : pd.getPropertyType();
                continue;
            }
            if (MapParameterBean.class.isInstance(value) && (map = ((MapParameterBean)value).getParameterMap()).containsKey(currentName)) {
                value = map.get(currentName);
                clazz = value != null ? value.getClass() : null;
                continue;
            }
            if (Map.class.isInstance(value)) {
                map = (Map)value;
                clazz = (value = map.get(currentName)) != null ? value.getClass() : null;
                continue;
            }
            if (List.class.isInstance(value) && currentName.startsWith("get(") && currentName.endsWith(")")) {
                List list = (List)value;
                String exp = Srl.extractScopeFirst(currentName, "get(", ")").getContent();
                try {
                    Integer index = DfTypeUtil.toInteger(exp);
                    value = list.get(index);
                }
                catch (NumberFormatException e) {
                    this.throwListIndexNotNumberException(exp, e);
                }
                catch (IndexOutOfBoundsException e) {
                    this.throwListIndexOutOfBoundsException(exp, e);
                }
                clazz = value != null ? value.getClass() : null;
                continue;
            }
            this.throwNotFoundPropertyException(clazz, currentName);
        }
        this.adjustLikeSearchDBWay(filteringBindOption);
        boundValue.setTargetValue(value);
        boundValue.setTargetType(clazz);
        boundValue.setFilteringBindOption(filteringBindOption);
    }

    protected DfBeanDesc getBeanDesc(Class<?> clazz) {
        return DfBeanDescFactory.getBeanDesc(clazz);
    }

    protected boolean hasLikeSearchProperty(DfBeanDesc beanDesc, String currentName, Object pmb) {
        String propertyName = this.buildLikeSearchPropertyName(currentName);
        boolean result = false;
        if (beanDesc.hasPropertyDesc(propertyName)) {
            result = true;
        } else if (MapParameterBean.class.isInstance(pmb)) {
            Map map = ((MapParameterBean)pmb).getParameterMap();
            result = map.containsKey(propertyName);
        } else if (Map.class.isInstance(pmb)) {
            result = ((Map)pmb).containsKey(propertyName);
        }
        return result;
    }

    protected FilteringBindOption getFilteringBindOption(DfBeanDesc beanDesc, String currentName, Object pmb) {
        FilteringBindOption option;
        String propertyName = this.buildLikeSearchPropertyName(currentName);
        if (beanDesc.hasPropertyDesc(propertyName)) {
            DfPropertyDesc pb = beanDesc.getPropertyDesc(propertyName);
            option = (FilteringBindOption)pb.getValue(pmb);
        } else if (MapParameterBean.class.isInstance(pmb)) {
            Map map = ((MapParameterBean)pmb).getParameterMap();
            option = (FilteringBindOption)map.get(propertyName);
        } else if (Map.class.isInstance(pmb)) {
            option = (FilteringBindOption)((Map)pmb).get(propertyName);
        } else {
            String msg = "Not found the like-search property: name=" + propertyName;
            throw new IllegalStateException(msg);
        }
        return option;
    }

    protected String buildLikeSearchPropertyName(String resourceName) {
        return resourceName + LIKE_SEARCH_OPTION_SUFFIX;
    }

    protected void adjustLikeSearchDBWay(FilteringBindOption option) {
    }

    protected boolean isLastLoop(int pos) {
        return this._nameList.size() == pos + 1;
    }

    protected Object getPropertyValue(Class<?> beanType, Object beanValue, String currentName, DfPropertyDesc pd) {
        try {
            return pd.getValue(beanValue);
        }
        catch (DfBeanIllegalPropertyException e) {
            this.throwPropertyReadFailureException(beanType, currentName, e);
            return null;
        }
    }

    protected Object invokeGetter(Method method, Object target) {
        return DfReflectionUtil.invoke(method, target, null);
    }

    protected void throwPropertyReadFailureException(Class<?> targetType, String propertyName, DfBeanIllegalPropertyException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Failed to read the property on the " + this._commentType.textName() + ".");
        br.addItem("Advice");
        br.addElement("Please confirm your comment properties.");
        br.addElement("(readable? accessbile? and so on...)");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("Illegal Property");
        br.addElement(DfTypeUtil.toClassTitle(targetType) + "." + propertyName);
        br.addItem("Exception Message");
        br.addElement(e.getClass());
        br.addElement(e.getMessage());
        Throwable cause = e.getCause();
        if (cause != null) {
            br.addElement(cause.getClass());
            br.addElement(cause.getMessage());
            Throwable nextCause = cause.getCause();
            if (nextCause != null) {
                br.addElement(nextCause.getClass());
                br.addElement(nextCause.getMessage());
            }
        }
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (ParameterCommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentPropertyReadFailureException(msg, e);
        }
        if (ParameterCommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentPropertyReadFailureException(msg, e);
        }
        if (ParameterCommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentPropertyReadFailureException(msg, e);
        }
        throw new BindVariableCommentPropertyReadFailureException(msg, e);
    }

    protected void throwNotFoundPropertyException(Class<?> targetType, String notFoundProperty) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The property on the " + this._commentType.textName() + " was not found.");
        br.addItem("Advice");
        br.addElement("Please confirm the existence of your property on your arguments.");
        br.addElement("And has the property had misspelling?");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("NotFound Property");
        br.addElement((targetType != null ? targetType.getName() + "#" : "") + notFoundProperty);
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (ParameterCommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentNotFoundPropertyException(msg);
        }
        if (ParameterCommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentNotFoundPropertyException(msg);
        }
        if (ParameterCommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentNotFoundPropertyException(msg);
        }
        throw new BindVariableCommentNotFoundPropertyException(msg);
    }

    protected void throwListIndexNotNumberException(String notNumberIndex, NumberFormatException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The list index on the " + this._commentType.textName() + " was not number.");
        br.addItem("Advice");
        br.addElement("Please confirm the index on your comment.");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("NotNumber Index");
        br.addElement(notNumberIndex);
        br.addItem("NumberFormatException");
        br.addElement(e.getMessage());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (ParameterCommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentListIndexNotNumberException(msg, e);
        }
        if (ParameterCommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentListIndexNotNumberException(msg, e);
        }
        if (ParameterCommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentListIndexNotNumberException(msg, e);
        }
        throw new BindVariableCommentListIndexNotNumberException(msg, e);
    }

    protected void throwListIndexOutOfBoundsException(String numberIndex, IndexOutOfBoundsException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The list index on the " + this._commentType.textName() + " was out of bounds.");
        br.addItem("Advice");
        br.addElement("Please confirm the index on your comment.");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("OutOfBounds Index");
        br.addElement(numberIndex);
        br.addItem("IndexOutOfBoundsException");
        br.addElement(e.getMessage());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (ParameterCommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentListIndexOutOfBoundsException(msg, e);
        }
        if (ParameterCommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentListIndexOutOfBoundsException(msg, e);
        }
        if (ParameterCommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentListIndexOutOfBoundsException(msg, e);
        }
        throw new BindVariableCommentListIndexOutOfBoundsException(msg, e);
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }
}

