/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.BooleanSupplier;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.twowaysql.style.BoundDateDisplayStyle;
import org.dbflute.twowaysql.style.BoundDateDisplayTimeZoneProvider;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class DisplaySqlBuilder {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIMESTAMP_FORMAT = DfTypeUtil.HYPHENED_TIMESTAMP_PATTERN;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String NULL = "null";
    protected final BoundDateDisplayStyle _dateDisplayStyle;

    public DisplaySqlBuilder(BoundDateDisplayStyle dateDisplayStyle) {
        if (dateDisplayStyle == null) {
            String msg = "The argument 'dateDisplayStyle' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._dateDisplayStyle = dateDisplayStyle;
    }

    public String buildDisplaySql(String sql, Object[] args) {
        EmbeddingProcessor processor = new EmbeddingProcessor();
        return processor.embed(sql, args);
    }

    public String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return this.quote(bindVariable.toString());
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof LocalDate) {
            return this.buildLocalDateText(bindVariable);
        }
        if (bindVariable instanceof LocalDateTime) {
            return this.buildLocalDateTimeText(bindVariable);
        }
        if (bindVariable instanceof LocalTime) {
            return this.buildLocalTimeText(bindVariable);
        }
        if (bindVariable instanceof Timestamp) {
            return this.buildTimestampText(bindVariable);
        }
        if (bindVariable instanceof Time) {
            return this.buildTimeText(bindVariable);
        }
        if (bindVariable instanceof Date) {
            return this.buildDateText(bindVariable);
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return NULL;
        }
        return this.quote(bindVariable.toString());
    }

    protected String buildLocalDateText(Object bindVariable) {
        return this.processLocalDateDisplay((LocalDate)bindVariable, this.getLocalDatePattern());
    }

    protected String buildLocalDateTimeText(Object bindVariable) {
        return this.processLocalDateTimeDisplay((LocalDateTime)bindVariable, this.getLocalDateTimePattern());
    }

    protected String buildLocalTimeText(Object bindVariable) {
        return this.processLocalTimeDisplay((LocalTime)bindVariable, this.getLocalTimePattern());
    }

    protected String buildDateText(Object bindVariable) {
        return this.processDateDisplay((Date)bindVariable, this.getDatePattern());
    }

    protected String buildTimestampText(Object bindVariable) {
        return this.processDateDisplay((Date)bindVariable, this.getTimestampPattern());
    }

    protected String buildTimeText(Object bindVariable) {
        return this.quote(DfTypeUtil.toString((Date)bindVariable, this.getTimePattern()));
    }

    protected String processLocalDateDisplay(LocalDate date, String format) {
        DateFormatResource resource = this.analyzeDateFormat(format);
        String disp = DfTypeUtil.toStringDate(date, resource.getFormat());
        disp = this.filterBCPrefix(disp, () -> this.isBCPrefixTarget(date, resource));
        return this.quote(disp, resource);
    }

    protected String processLocalDateTimeDisplay(LocalDateTime date, String format) {
        DateFormatResource resource = this.analyzeDateFormat(format);
        String disp = DfTypeUtil.toStringDate(date, resource.getFormat());
        disp = this.filterBCPrefix(disp, () -> this.isBCPrefixTarget(date, resource));
        return this.quote(disp, resource);
    }

    protected String processLocalTimeDisplay(LocalTime date, String format) {
        DateFormatResource resource = this.analyzeDateFormat(format);
        String disp = DfTypeUtil.toStringDate(date, resource.getFormat());
        return this.quote(disp, resource);
    }

    protected String processDateDisplay(Date date, String format) {
        DateFormatResource resource = this.analyzeDateFormat(format);
        TimeZone realZone = this.getRealTimeZone();
        Locale realLocale = this.getRealLocale();
        String disp = DfTypeUtil.toStringDate(date, realZone, resource.getFormat(), realLocale);
        disp = this.filterBCPrefix(disp, () -> this.isBCPrefixTarget(date, resource));
        return this.quote(disp, resource);
    }

    protected String filterBCPrefix(String disp, BooleanSupplier noArgLambda) {
        return noArgLambda.getAsBoolean() ? "BC" + disp : disp;
    }

    protected String getLocalDatePattern() {
        String datePattern = this._dateDisplayStyle.getDatePattern();
        return datePattern != null ? datePattern : DEFAULT_DATE_FORMAT;
    }

    protected String getLocalDateTimePattern() {
        String datePattern = this._dateDisplayStyle.getTimestampPattern();
        return datePattern != null ? datePattern : DEFAULT_TIMESTAMP_FORMAT;
    }

    protected String getLocalTimePattern() {
        String datePattern = this._dateDisplayStyle.getTimePattern();
        return datePattern != null ? datePattern : DEFAULT_TIME_FORMAT;
    }

    protected String getDatePattern() {
        String datePattern = this._dateDisplayStyle.getDatePattern();
        return datePattern != null ? datePattern : DEFAULT_DATE_FORMAT;
    }

    protected String getTimestampPattern() {
        String timestampPattern = this._dateDisplayStyle.getTimestampPattern();
        return timestampPattern != null ? timestampPattern : DEFAULT_TIMESTAMP_FORMAT;
    }

    protected String getTimePattern() {
        String timePattern = this._dateDisplayStyle.getTimePattern();
        return timePattern != null ? timePattern : DEFAULT_TIME_FORMAT;
    }

    protected TimeZone getRealTimeZone() {
        BoundDateDisplayTimeZoneProvider provider = this._dateDisplayStyle.getTimeZoneProvider();
        return provider != null ? provider.provide() : this.getDBFluteSystemFinalTimeZone();
    }

    protected TimeZone getDBFluteSystemFinalTimeZone() {
        return DBFluteSystem.getFinalTimeZone();
    }

    protected Locale getRealLocale() {
        return this.getDBFluteSystemFinalLocale();
    }

    protected Locale getDBFluteSystemFinalLocale() {
        return DBFluteSystem.getFinalLocale();
    }

    protected boolean isBCPrefixTarget(Date date, DateFormatResource resource) {
        return DfTypeUtil.isDateBC(date) && this.judgeBCPrefixTargetFormat(resource.getFormat());
    }

    protected boolean isBCPrefixTarget(LocalDate date, DateFormatResource resource) {
        return DfTypeUtil.isLocalDateBC(date) && this.judgeBCPrefixTargetFormat(resource.getFormat());
    }

    protected boolean isBCPrefixTarget(LocalDateTime date, DateFormatResource resource) {
        return DfTypeUtil.isLocalDateBC(date.toLocalDate()) && this.judgeBCPrefixTargetFormat(resource.getFormat());
    }

    protected boolean judgeBCPrefixTargetFormat(String format) {
        return format.startsWith("yyyy") && !format.contains("G");
    }

    protected DateFormatResource analyzeDateFormat(String format) {
        String rear;
        int dfMarkEndIndex;
        DateFormatResource resource = new DateFormatResource();
        String dfMark = "$df:{";
        int dfmarkBeginIndex = format.indexOf("$df:{");
        if (dfmarkBeginIndex >= 0 && (dfMarkEndIndex = (rear = format.substring(dfmarkBeginIndex + "$df:{".length())).indexOf("}")) >= 0) {
            resource.setFormat(rear.substring(0, dfMarkEndIndex));
            resource.setPrefix(format.substring(0, dfmarkBeginIndex));
            resource.setSuffix(rear.substring(dfMarkEndIndex + "}".length()));
            return resource;
        }
        resource.setFormat(format);
        return resource;
    }

    protected String quote(String text) {
        return Srl.quoteSingle(text);
    }

    protected String quote(String text, DateFormatResource resource) {
        String result = this.quote(text);
        result = Srl.connectPrefix(result, resource.getPrefix(), "");
        result = Srl.connectSuffix(result, resource.getSuffix(), "");
        return result;
    }

    protected static class DateFormatResource {
        protected String _format;
        protected String _prefix;
        protected String _suffix;

        protected DateFormatResource() {
        }

        public String getFormat() {
            return this._format;
        }

        public void setFormat(String format) {
            this._format = format;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public void setPrefix(String prefix) {
            this._prefix = prefix;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public void setSuffix(String suffix) {
            this._suffix = suffix;
        }
    }

    protected class EmbeddingProcessor {
        protected int _processPointer = 0;
        protected int _loopIndex = 0;
        protected int _questionMarkIndex = 0;
        protected int _quotationScopeBeginIndex = 0;
        protected int _quotationScopeEndIndex = 0;
        protected int _blockCommentBeginIndex = 0;
        protected int _blockCommentEndIndex = 0;

        protected EmbeddingProcessor() {
        }

        public String embed(String sql, Object[] args) {
            if (args == null || args.length == 0) {
                return sql;
            }
            StringBuilder sb = new StringBuilder(sql.length() + args.length * 15);
            while (true) {
                this._questionMarkIndex = sql.indexOf(63, this._processPointer);
                this.setupQuestionMarkIndex(sql);
                if (this._questionMarkIndex < 0) break;
                if (this._questionMarkIndex == 0) {
                    this.processBindVariable(sb, sql, args);
                    continue;
                }
                this.setupBlockCommentIndex(sql);
                if (this.hasBlockComment()) {
                    if (this.isBeforeBlockComment()) {
                        this.processQuotationScope(sb, sql, args);
                        continue;
                    }
                    this.processBlockComment(sb, sql, args);
                    continue;
                }
                this.processQuotationScope(sb, sql, args);
            }
            this.processLastPart(sb, sql, args);
            return sb.toString();
        }

        protected void processBindVariable(StringBuilder sb, String sql, Object[] args) {
            this.assertArgumentSize(args, sql);
            String beforeParameter = sql.substring(this._processPointer, this._questionMarkIndex);
            String bindVariableText = DisplaySqlBuilder.this.getBindVariableText(args[this._loopIndex]);
            sb.append(beforeParameter).append(bindVariableText);
            this._processPointer = this._questionMarkIndex + 1;
            ++this._loopIndex;
        }

        protected void assertArgumentSize(Object[] args, String sql) {
            if (args.length <= this._loopIndex) {
                ExceptionMessageBuilder br = new ExceptionMessageBuilder();
                br.addNotice("The count of bind arguments is illegal for DisplaySql.");
                br.addItem("ExecutedSql");
                br.addElement(sql);
                br.addItem("Arguments");
                br.addElement(Arrays.asList(args));
                br.addElement("count=" + args.length);
                String msg = br.buildExceptionMessage();
                throw new IllegalStateException(msg);
            }
        }

        protected void processBlockComment(StringBuilder sb, String sql, Object[] args) {
            int nextPointer = this._blockCommentEndIndex + 1;
            String beforeCommentEnd = sql.substring(this._processPointer, nextPointer);
            sb.append(beforeCommentEnd);
            this._processPointer = nextPointer;
        }

        protected void processQuotationScope(StringBuilder sb, String sql, Object[] args) {
            this.setupQuotationScopeIndex(sql);
            if (this.isQuotationScopeOverBlockComment()) {
                this._quotationScopeBeginIndex = -1;
                this._quotationScopeEndIndex = -1;
            }
            if (this.hasQuotationScope()) {
                if (this.isInQuotationScope()) {
                    int nextPointer = this._quotationScopeEndIndex + 1;
                    String beforeScopeEnd = sql.substring(this._processPointer, nextPointer);
                    sb.append(beforeScopeEnd);
                    this._processPointer = nextPointer;
                } else {
                    this.processBindVariable(sb, sql, args);
                }
            } else {
                this.processBindVariable(sb, sql, args);
            }
        }

        protected void processLastPart(StringBuilder sb, String sql, Object[] args) {
            String lastPart = sql.substring(this._processPointer);
            sb.append(lastPart);
            this._processPointer = 0;
            this._loopIndex = 0;
        }

        protected void setupQuestionMarkIndex(String sql) {
            this._questionMarkIndex = sql.indexOf(63, this._processPointer);
        }

        protected void setupBlockCommentIndex(String sql) {
            this._blockCommentBeginIndex = sql.indexOf("/*", this._processPointer);
            this._blockCommentEndIndex = sql.indexOf("*/", this._blockCommentBeginIndex + 1);
        }

        protected void setupQuotationScopeIndex(String sql) {
            this._quotationScopeBeginIndex = sql.indexOf(39, this._processPointer);
            this._quotationScopeEndIndex = sql.indexOf(39, this._quotationScopeBeginIndex + 1);
        }

        protected boolean hasBlockComment() {
            return this._blockCommentBeginIndex >= 0 && this._blockCommentEndIndex >= 0;
        }

        protected boolean hasQuotationScope() {
            return this._quotationScopeBeginIndex >= 0 && this._quotationScopeEndIndex >= 0;
        }

        protected boolean isBeforeBlockComment() {
            if (!this.hasBlockComment()) {
                return false;
            }
            return this._questionMarkIndex < this._blockCommentBeginIndex;
        }

        protected boolean isInBlockComment() {
            if (!this.hasBlockComment()) {
                return false;
            }
            return this._blockCommentBeginIndex < this._questionMarkIndex && this._questionMarkIndex < this._blockCommentEndIndex;
        }

        protected boolean isInQuotationScope() {
            if (!this.hasQuotationScope()) {
                return false;
            }
            return this._quotationScopeBeginIndex < this._questionMarkIndex && this._questionMarkIndex < this._quotationScopeEndIndex;
        }

        protected boolean isQuotationScopeOverBlockComment() {
            return this.hasBlockComment() && this.hasQuotationScope() && this._quotationScopeEndIndex > this._blockCommentBeginIndex;
        }
    }
}

