/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.dbway.DBDef;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.metadata.TnProcedureMetaData;
import org.dbflute.s2dao.metadata.TnProcedureParameterType;
import org.dbflute.s2dao.metadata.TnProcedureValueTypeProvider;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class TnProcedureMetaDataFactory {
    protected final TnFieldProcedureAnnotationReader _annotationReader = new TnFieldProcedureAnnotationReader();
    protected final TnProcedureValueTypeProvider _valueTypeProvider = new TnProcedureValueTypeProvider();

    public TnProcedureMetaData createProcedureMetaData(String procedureName, Class<?> pmbType) {
        TnProcedureMetaData procedureMetaData = new TnProcedureMetaData(procedureName);
        if (pmbType == null) {
            return procedureMetaData;
        }
        if (!this.isDtoType(pmbType)) {
            throw new IllegalStateException("The pmb type was Not DTO type: " + pmbType.getName());
        }
        DfBeanDesc pmbDesc = DfBeanDescFactory.getBeanDesc(pmbType);
        List<String> proppertyNameList = pmbDesc.getProppertyNameList();
        for (String propertyName : proppertyNameList) {
            DfPropertyDesc parameterDesc = pmbDesc.getPropertyDesc(propertyName);
            if (!parameterDesc.isReadable() || !parameterDesc.isWritable()) continue;
            this.registerParameterType(procedureMetaData, parameterDesc);
        }
        procedureMetaData.fix();
        return procedureMetaData;
    }

    protected void registerParameterType(TnProcedureMetaData procedureMetaData, DfPropertyDesc parameterDesc) {
        TnProcedureParameterType ppt = this.getProcedureParameterType(parameterDesc);
        if (ppt == null) {
            return;
        }
        procedureMetaData.addParameterType(ppt);
    }

    protected TnProcedureParameterType getProcedureParameterType(DfPropertyDesc parameterDesc) {
        String specificationExp = this._annotationReader.getParameterSpecification(parameterDesc);
        if (specificationExp == null) {
            return null;
        }
        TnProcedureParameterSpec spec = this.parseParameterSpec(specificationExp, parameterDesc);
        String type = spec.getParameterType();
        TnProcedureParameterType ppt = this.createProcedureParameterType(parameterDesc);
        if (type.equalsIgnoreCase("in")) {
            ppt.setInType(true);
        } else if (type.equalsIgnoreCase("out")) {
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase("inout")) {
            ppt.setInType(true);
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase("return")) {
            ppt.setOutType(true);
            ppt.setReturnType(true);
        } else if (type.equalsIgnoreCase("notParamResult")) {
            ppt.setNotParamResultType(true);
        } else {
            String msg = "The parameter type should be 'in, out, inout, return, notParamResult':";
            msg = msg + " type=" + type;
            msg = msg + " class=" + DfTypeUtil.toClassTitle(parameterDesc.getBeanDesc().getBeanClass());
            msg = msg + " property=" + parameterDesc.getPropertyName();
            throw new IllegalStateException(msg);
        }
        ppt.setParameterOrder(spec.getParameterOrder());
        ppt.setValueType(this.findValueType(parameterDesc));
        return ppt;
    }

    protected TnProcedureParameterType createProcedureParameterType(final DfPropertyDesc parameterDesc) {
        Type genericReturnType = parameterDesc.getReadMethod().getGenericReturnType();
        Class<?> elementType = DfReflectionUtil.getGenericFirstClass(genericReturnType);
        return new TnProcedureParameterType(new TnProcedureParameterType.TnProcedureParameterAccessor(){

            @Override
            public Object getValue(Object target) {
                return parameterDesc.getValue(target);
            }

            @Override
            public void setValue(Object target, Object value) {
                parameterDesc.setValue(target, value);
            }
        }, parameterDesc.getPropertyName(), parameterDesc.getPropertyType(), elementType);
    }

    protected TnProcedureParameterSpec parseParameterSpec(String specExp, DfPropertyDesc parameterDesc) {
        List<String> list = Srl.splitListTrimmed(specExp, ",");
        if (list.size() != 2) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The size of parameter spec elements was illegal.");
            br.addItem("ProcedurePmb");
            br.addElement(DfTypeUtil.toClassTitle(parameterDesc.getBeanDesc().getBeanClass()));
            br.addItem("Parameter");
            br.addElement(parameterDesc.getPropertyName());
            br.addElement(parameterDesc.getPropertyType());
            br.addItem("Parameter Spec");
            br.addElement(specExp);
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg);
        }
        String parameterType = list.get(0);
        String parameterIndex = list.get(1);
        TnProcedureParameterSpec spec = new TnProcedureParameterSpec();
        spec.setParameterType(parameterType);
        try {
            spec.setParameterOrder(DfTypeUtil.toInteger(parameterIndex));
        }
        catch (NumberFormatException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Failed to parse the parameter index as Integer.");
            br.addItem("ProcedurePmb");
            br.addElement(DfTypeUtil.toClassTitle(parameterDesc.getBeanDesc().getBeanClass()));
            br.addItem("Parameter");
            br.addElement(parameterDesc.getPropertyName());
            br.addElement(parameterDesc.getPropertyType());
            br.addItem("Parameter Spec");
            br.addElement(specExp);
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg);
        }
        return spec;
    }

    protected ValueType findValueType(DfPropertyDesc parameterDesc) {
        Class<?> pmbType = parameterDesc.getBeanDesc().getBeanClass();
        String paramName = parameterDesc.getPropertyName();
        Class<?> paramType = parameterDesc.getPropertyType();
        Object valueTypeDef = this._annotationReader.getValueType(parameterDesc);
        if (valueTypeDef instanceof ValueType) {
            return (ValueType)valueTypeDef;
        }
        String keyName = valueTypeDef != null ? valueTypeDef.toString() : null;
        DBDef dbdef = ResourceContext.currentDBDef();
        return this._valueTypeProvider.provide(pmbType, paramName, paramType, keyName, dbdef);
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    protected boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    protected boolean isDtoType(Class<?> clazz) {
        return !this.isSimpleType(clazz) && !this.isContainerType(clazz);
    }

    protected boolean isSimpleType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return clazz == String.class || clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz) || clazz == byte[].class;
    }

    protected boolean isContainerType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    protected static class TnFieldProcedureAnnotationReader {
        protected static final String PARAMETER_SUFFIX = "_PROCEDURE_PARAMETER";
        protected static final String VALUE_TYPE_SUFFIX = "_VALUE_TYPE";

        protected TnFieldProcedureAnnotationReader() {
        }

        public String getParameterSpecification(DfPropertyDesc propertyDesc) {
            String propertyName = propertyDesc.getPropertyName();
            String annotationName = propertyName + PARAMETER_SUFFIX;
            DfBeanDesc pmbDesc = propertyDesc.getBeanDesc();
            if (pmbDesc.hasField(annotationName)) {
                Field field = pmbDesc.getField(annotationName);
                return (String)DfReflectionUtil.getValue(field, null);
            }
            return null;
        }

        public Object getValueType(DfPropertyDesc propertyDesc) {
            String propertyName = propertyDesc.getPropertyName();
            String annotationName = propertyName + VALUE_TYPE_SUFFIX;
            DfBeanDesc pmbDesc = propertyDesc.getBeanDesc();
            if (pmbDesc.hasField(annotationName)) {
                Field field = pmbDesc.getField(annotationName);
                return DfReflectionUtil.getValue(field, null);
            }
            return null;
        }

        protected Object getValue(Field field, Object target) {
            try {
                return field.get(target);
            }
            catch (IllegalAccessException e) {
                String msg = "The getting of the field threw the exception:";
                msg = msg + " class=" + DfTypeUtil.toClassTitle(field.getDeclaringClass());
                msg = msg + " field=" + field.getName();
                throw new IllegalStateException(msg, e);
            }
        }
    }

    protected static class TnProcedureParameterSpec {
        protected String _parameterType;
        protected Integer _parameterOrder;

        protected TnProcedureParameterSpec() {
        }

        public String getParameterType() {
            return this._parameterType;
        }

        public void setParameterType(String parameterType) {
            this._parameterType = parameterType;
        }

        public Integer getParameterOrder() {
            return this._parameterOrder;
        }

        public void setParameterOrder(Integer parameterOrder) {
            this._parameterOrder = parameterOrder;
        }
    }
}

