/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dbflute.jdbc.DataSourceHandler;

public class HandlingDataSourceWrapper
implements DataSource {
    private final DataSource _dataSource;
    private final DataSourceHandler _dataSourceHandler;

    public HandlingDataSourceWrapper(DataSource dataSource, DataSourceHandler dataSourceHandler) {
        if (dataSource == null) {
            String msg = "The argument 'dataSource' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        if (dataSourceHandler == null) {
            String msg = "The argument 'dataSourceHandler' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._dataSource = dataSource;
        this._dataSourceHandler = dataSourceHandler;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._dataSourceHandler.getConnection(this._dataSource);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this._dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this._dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this._dataSource.setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._dataSource.isWrapperFor(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String toString() {
        return super.toString() + ":{" + this._dataSource + "}";
    }
}

