/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.hacomment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.infra.doc.hacomment.DfHacoMapPropertyPart;

public class DfHacoMapDiffPart {
    protected final String diffCode;
    protected final String diffDate;
    protected final Map<String, DfHacoMapPropertyPart> propertyMap = new LinkedHashMap<String, DfHacoMapPropertyPart>();

    public DfHacoMapDiffPart(String diffCode, String diffDate, DfHacoMapPropertyPart propertyPart) {
        this.diffCode = diffCode;
        this.diffDate = diffDate;
        this.addProperty(propertyPart);
    }

    public DfHacoMapDiffPart(String diffCode, String diffDate, List<DfHacoMapPropertyPart> propertyPartList) {
        this.diffCode = diffCode;
        this.diffDate = diffDate;
        propertyPartList.forEach(propertyPart -> this.addProperty((DfHacoMapPropertyPart)propertyPart));
    }

    public DfHacoMapDiffPart(Map<String, Object> historyPartMap) {
        this.diffCode = (String)historyPartMap.get("diffCode");
        this.diffDate = (String)historyPartMap.get("diffDate");
        List propertyMapList = (List)historyPartMap.get("propertyList");
        propertyMapList.stream().map(propertyMap -> new DfHacoMapPropertyPart((Map<String, Object>)propertyMap)).forEach(property -> this.propertyMap.put(property.getPieceCode(), (DfHacoMapPropertyPart)property));
    }

    public Map<String, Object> convertPickupMap() {
        List propertyMapList = this.getPropertyList().stream().map(propertyPart -> propertyPart.convertToMap()).collect(Collectors.toList());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("diffCode", this.diffCode);
        map.put("diffDate", this.diffDate);
        map.put("propertyList", propertyMapList);
        return map;
    }

    public String getDiffCode() {
        return this.diffCode;
    }

    public String getDiffDate() {
        return this.diffDate;
    }

    public List<DfHacoMapPropertyPart> getPropertyList() {
        return Collections.unmodifiableList(new ArrayList<DfHacoMapPropertyPart>(this.propertyMap.values()));
    }

    public void addProperty(DfHacoMapPropertyPart property) {
        this.propertyMap.put(property.getPieceCode(), property);
    }
}

