/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.sqlclause.orderby;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dbflute.cbean.ordering.ManualOrderOption;
import org.dbflute.cbean.sqlclause.orderby.OrderByElement;

public class OrderByClause
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<OrderByElement> _orderByList = new ArrayList<OrderByElement>(3);

    public void addOrderByElement(OrderByElement orderByElement) {
        this._orderByList.add(orderByElement);
    }

    public void insertFirstOrderByElement(OrderByElement orderByElement) {
        this._orderByList.add(0, orderByElement);
    }

    public void reverseAll() {
        Iterator<OrderByElement> ite = this._orderByList.iterator();
        while (ite.hasNext()) {
            ite.next().reverse();
        }
    }

    public void exchangeFirstOrderByElementForLastOne() {
        if (this._orderByList.size() > 1) {
            OrderByElement first = this._orderByList.get(0);
            OrderByElement last = this._orderByList.get(this._orderByList.size() - 1);
            this._orderByList.set(0, last);
            this._orderByList.set(this._orderByList.size() - 1, first);
        }
    }

    public void addNullsFirstToPreviousOrderByElement(OrderByNullsSetupper filter) {
        if (this._orderByList.isEmpty()) {
            return;
        }
        OrderByElement last = this._orderByList.get(this._orderByList.size() - 1);
        last.setOrderByNullsSetupper(filter, true);
    }

    public void addNullsLastToPreviousOrderByElement(OrderByNullsSetupper filter) {
        if (this._orderByList.isEmpty()) {
            return;
        }
        OrderByElement last = this._orderByList.get(this._orderByList.size() - 1);
        last.setOrderByNullsSetupper(filter, false);
    }

    public void addManualOrderByElement(ManualOrderOption mob) {
        if (this._orderByList.isEmpty()) {
            return;
        }
        this.getOrderByLastElement().setManualOrderOption(mob);
    }

    public List<OrderByElement> getOrderByList() {
        return this._orderByList;
    }

    public OrderByElement getOrderByFirstElement() {
        if (this._orderByList.isEmpty()) {
            return null;
        }
        return this._orderByList.get(0);
    }

    public OrderByElement getOrderByLastElement() {
        if (this._orderByList.isEmpty()) {
            return null;
        }
        return this._orderByList.get(this._orderByList.size() - 1);
    }

    public String getOrderByClause() {
        return this.getOrderByClause(null);
    }

    public String getOrderByClause(Map<String, String> selectClauseRealColumnAliasMap) {
        if (this._orderByList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String delimiter = ", ";
        for (OrderByElement element : this._orderByList) {
            sb.append(", ");
            if (selectClauseRealColumnAliasMap != null) {
                sb.append(element.getElementClause(selectClauseRealColumnAliasMap));
                continue;
            }
            sb.append(element.getElementClause());
        }
        sb.delete(0, ", ".length()).insert(0, "order by ");
        return sb.toString();
    }

    public boolean isSameOrderByColumn(String orderByProperty) {
        ArrayList<String> orderByList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(orderByProperty, "/");
        while (st.hasMoreElements()) {
            orderByList.add(st.nextToken());
        }
        if (this._orderByList.size() != orderByList.size()) {
            return false;
        }
        int count = 0;
        for (String columnFullName : orderByList) {
            OrderByElement element = this._orderByList.get(count);
            if (!element.getColumnFullName().equals(columnFullName)) {
                return false;
            }
            ++count;
        }
        return true;
    }

    public boolean isFirstElementAsc() {
        if (this.isEmpty()) {
            String msg = "This order-by clause is empty: " + this.toString();
            throw new IllegalStateException(msg);
        }
        OrderByElement element = this._orderByList.get(0);
        return element.isAsc();
    }

    public boolean isFirstElementDesc() {
        return !this.isFirstElementAsc();
    }

    public boolean isSameAsFirstElementAliasName(String expectedAliasName) {
        if (this.isEmpty()) {
            String msg = "This order-by clause is empty: " + this.toString();
            throw new RuntimeException(msg);
        }
        OrderByElement element = this._orderByList.get(0);
        String actualAliasName = element.getAliasName();
        if (actualAliasName != null && expectedAliasName != null) {
            return actualAliasName.equalsIgnoreCase(expectedAliasName);
        }
        return false;
    }

    public boolean isSameAsFirstElementColumnName(String expectedColumnName) {
        if (this.isEmpty()) {
            String msg = "This order-by clause is empty: " + this.toString();
            throw new RuntimeException(msg);
        }
        OrderByElement element = this._orderByList.get(0);
        String actualColumnName = element.getColumnName();
        if (actualColumnName != null && expectedColumnName != null) {
            return actualColumnName.equalsIgnoreCase(expectedColumnName);
        }
        return false;
    }

    public boolean isEmpty() {
        return this._orderByList.isEmpty();
    }

    public Iterator<OrderByElement> iterator() {
        return this._orderByList.iterator();
    }

    public void clear() {
        this._orderByList.clear();
    }

    public String toString() {
        return this._orderByList.toString();
    }

    public static interface OrderByNullsSetupper {
        public String setup(String var1, String var2, boolean var3);
    }
}

