/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.writable;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dbflute.Entity;
import org.dbflute.bhv.writable.WritableOption;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.coption.StatementConfigCall;
import org.dbflute.cbean.scoping.SpecifyQuery;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.PrimaryInfo;
import org.dbflute.exception.BatchInsertColumnModifiedPropertiesFragmentedException;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.exception.SpecifyUpdateColumnInvalidException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.jdbc.StatementConfig;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;

public class InsertOption<CB extends ConditionBean>
implements WritableOption<CB> {
    public static final Long VERSION_NO_FIRST_VALUE = 0L;
    protected SpecifyQuery<CB> _insertColumnSpecification;
    protected CB _insertColumnSpecifiedCB;
    protected Set<String> _forcedSpecifiedInsertColumnSet;
    protected boolean _exceptCommonColumnForcedSpecified;
    protected boolean _insertColumnModifiedPropertiesFragmentedAllowed = true;
    protected boolean _compatibleBatchInsertDefaultEveryColumn;
    protected boolean _compatibleInsertColumnNotNullOnly;
    protected boolean _disableCommonColumnAutoSetup;
    protected boolean _disablePrimaryKeyIdentity;
    protected Integer _batchInsertLoggingLimit;
    protected StatementConfig _insertStatementConfig;

    public void specify(SpecifyQuery<CB> insertColumnSpecification) {
        if (insertColumnSpecification == null) {
            String msg = "The argument 'insertColumnSpecification' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._insertColumnSpecification = insertColumnSpecification;
    }

    public void resolveInsertColumnSpecification(CB cb) {
        if (this._insertColumnSpecification == null) {
            return;
        }
        this._insertColumnSpecification.specify(cb);
        this._insertColumnSpecifiedCB = cb;
        if (!this._exceptCommonColumnForcedSpecified) {
            this.xacceptCommonColumnForcedSpecification(cb);
        }
    }

    public InsertOption<CB> exceptCommonColumnForcedSpecified() {
        this._exceptCommonColumnForcedSpecified = true;
        return this;
    }

    protected void xacceptCommonColumnForcedSpecification(CB cb) {
        List<ColumnInfo> beforeInsertList = cb.asDBMeta().getCommonColumnInfoBeforeInsertList();
        if (beforeInsertList == null || beforeInsertList.isEmpty()) {
            return;
        }
        for (ColumnInfo columnInfo : beforeInsertList) {
            this.addForcedSpecifiedInsertColumn(columnInfo);
        }
    }

    protected void addForcedSpecifiedInsertColumn(ColumnInfo columnInfo) {
        if (this._forcedSpecifiedInsertColumnSet == null) {
            this._forcedSpecifiedInsertColumnSet = DfCollectionUtil.newHashSet();
        }
        this._forcedSpecifiedInsertColumnSet.add(columnInfo.getColumnDbName());
    }

    public void xacceptInsertColumnModifiedPropertiesIfNeeds(List<? extends Entity> entityList) {
        if (entityList == null) {
            throw new IllegalArgumentException("The argument 'entityList' should not be null.");
        }
        if (this._insertColumnSpecification != null) {
            return;
        }
        if (entityList.isEmpty()) {
            return;
        }
        if (this.xisCompatibleBatchInsertDefaultEveryColumn()) {
            return;
        }
        final Entity firstEntity = entityList.get(0);
        if (firstEntity.createdBySelect()) {
            this.specify(new SpecifyQuery<CB>(){

                @Override
                public void specify(CB cb) {
                    List<ColumnInfo> infoList = firstEntity.asDBMeta().getColumnInfoList();
                    for (ColumnInfo info : infoList) {
                        if (info.isPrimary()) continue;
                        cb.localSp().xspecifyColumn(info.getColumnDbName());
                    }
                }
            });
        } else {
            final Set<String> targetProps = this.xgatherInsertColumnModifiedProperties(entityList, firstEntity);
            final DBMeta dbmeta = firstEntity.asDBMeta();
            this.specify(new SpecifyQuery<CB>(){

                @Override
                public void specify(CB cb) {
                    for (String prop : targetProps) {
                        ColumnInfo info = dbmeta.findColumnInfo(prop);
                        if (info.isPrimary()) continue;
                        cb.localSp().xspecifyColumn(info.getColumnDbName());
                    }
                }
            });
        }
    }

    public void xallowInsertColumnModifiedPropertiesFragmented() {
        this._insertColumnModifiedPropertiesFragmentedAllowed = true;
    }

    public void xdisallowInsertColumnModifiedPropertiesFragmented() {
        this._insertColumnModifiedPropertiesFragmentedAllowed = false;
    }

    public boolean xisInsertColumnModifiedPropertiesFragmentedAllowed() {
        return this._insertColumnModifiedPropertiesFragmentedAllowed;
    }

    protected Set<String> xgatherInsertColumnModifiedProperties(List<? extends Entity> entityList, Entity firstEntity) {
        if (this.xisInsertColumnModifiedPropertiesFragmentedAllowed()) {
            LinkedHashSet<String> mergedProps = new LinkedHashSet<String>();
            for (Entity entity : entityList) {
                mergedProps.addAll(entity.mymodifiedProperties());
            }
            return mergedProps;
        }
        Set<String> firstProps = firstEntity.mymodifiedProperties();
        for (Entity entity : entityList) {
            if (entity.mymodifiedProperties().equals(firstProps)) continue;
            this.throwBatchInsertColumnModifiedPropertiesFragmentedException(firstProps, entity);
        }
        return firstProps;
    }

    protected void throwBatchInsertColumnModifiedPropertiesFragmentedException(Set<String> baseProps, Entity entity) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The modified properties in the entity are fragmented as batch insert column.");
        br.addItem("Advice");
        br.addElement("You should specify the same-set columns to your entities.");
        br.addElement("For example:");
        br.addElement("");
        br.addElement("  (x): (BatchInsert)");
        br.addElement("    for (... : ...) {");
        br.addElement("        Member member = new Member();");
        br.addElement("        member.setMemberName(\"foo\");");
        br.addElement("        if (...) { // only a part of entities is set");
        br.addElement("            member.setBirthdate(currentDate());");
        br.addElement("        }");
        br.addElement("        memberList.add(member); // throws exception");
        br.addElement("    }");
        br.addElement("    memberBhv.batchInsert(memberList);");
        br.addElement("  (o): (BatchInsert)");
        br.addElement("    for (... : ...) {");
        br.addElement("        Member member = new Member();");
        br.addElement("        member.setMemberName(\"foo\");");
        br.addElement("        member.setBirthdate(currentDate()); // always set");
        br.addElement("        memberList.add(member); // all records are current date");
        br.addElement("    }");
        br.addElement("    memberBhv.batchInsert(memberList);");
        br.addElement("  (o): (BatchInsert)");
        br.addElement("    for (... : ...) {");
        br.addElement("        Member member = new Member();");
        br.addElement("        member.setMemberName(\"foo\");");
        br.addElement("        if (...) {");
        br.addElement("            member.setBirthdate(currentDate());");
        br.addElement("        } else {");
        br.addElement("            member.setBirthdate(null); // explicitly null");
        br.addElement("        }");
        br.addElement("        memberList.add(member);");
        br.addElement("    }");
        br.addElement("    memberBhv.batchInsert(memberList); // current date or null without default");
        br.addItem("Insert Table");
        br.addElement(entity.asDBMeta().getTableDbName());
        br.addItem("Base Properties");
        br.addElement(baseProps);
        br.addItem("Fragmented Entity");
        br.addElement(entity.asDBMeta().extractPrimaryKeyMap(entity));
        br.addItem("Fragmented Properties");
        br.addElement(entity.mymodifiedProperties());
        String msg = br.buildExceptionMessage();
        throw new BatchInsertColumnModifiedPropertiesFragmentedException(msg);
    }

    public void xtoBeCompatibleBatchInsertDefaultEveryColumn() {
        this._compatibleBatchInsertDefaultEveryColumn = true;
    }

    public boolean xisCompatibleBatchInsertDefaultEveryColumn() {
        return this._compatibleBatchInsertDefaultEveryColumn;
    }

    public void xtoBeCompatibleInsertColumnNotNullOnly() {
        this._compatibleInsertColumnNotNullOnly = true;
    }

    public boolean xisCompatibleInsertColumnNotNullOnly() {
        return this._compatibleInsertColumnNotNullOnly;
    }

    public void xcheckSpecifiedInsertColumnPrimaryKey() {
        if (this._insertColumnSpecification == null) {
            return;
        }
        this.assertInsertColumnSpecifiedCB();
        CB cb = this._insertColumnSpecifiedCB;
        String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        DBMeta dbmeta = cb.asDBMeta();
        if (dbmeta.hasPrimaryKey()) {
            PrimaryInfo pkInfo = dbmeta.getPrimaryInfo();
            List<ColumnInfo> pkList = pkInfo.getPrimaryColumnList();
            for (ColumnInfo pk : pkList) {
                String columnDbName = pk.getColumnDbName();
                if (!cb.getSqlClause().hasSpecifiedSelectColumn(basePointAliasName, columnDbName)) continue;
                String msg = "PK columns should not be allowed to specify as update columns: " + columnDbName;
                throw new SpecifyUpdateColumnInvalidException(msg);
            }
        }
    }

    public boolean hasSpecifiedInsertColumn() {
        return this._insertColumnSpecification != null;
    }

    public boolean isSpecifiedInsertColumn(String columnDbName) {
        if (this._forcedSpecifiedInsertColumnSet != null && this._forcedSpecifiedInsertColumnSet.contains(columnDbName)) {
            return true;
        }
        this.assertInsertColumnSpecifiedCB();
        SqlClause sqlClause = this._insertColumnSpecifiedCB.getSqlClause();
        return sqlClause.hasSpecifiedSelectColumn(sqlClause.getBasePointAliasName(), columnDbName);
    }

    protected void assertInsertColumnSpecifiedCB() {
        if (this._insertColumnSpecifiedCB == null) {
            String msg = "The CB for specification of update columns should be required here.";
            throw new IllegalStateException(msg);
        }
    }

    public InsertOption<CB> disableCommonColumnAutoSetup() {
        this._disableCommonColumnAutoSetup = true;
        return this;
    }

    public boolean isCommonColumnAutoSetupDisabled() {
        return this._disableCommonColumnAutoSetup;
    }

    public InsertOption<CB> disablePrimaryKeyIdentity() {
        this._disablePrimaryKeyIdentity = true;
        return this;
    }

    public boolean isPrimaryKeyIdentityDisabled() {
        return this._disablePrimaryKeyIdentity;
    }

    public void limitBatchInsertLogging(Integer batchInsertLoggingLimit) {
        this._batchInsertLoggingLimit = batchInsertLoggingLimit;
    }

    public Integer getBatchInsertLoggingLimit() {
        return this._batchInsertLoggingLimit;
    }

    public void configure(StatementConfigCall<StatementConfig> confLambda) {
        this.assertStatementConfigNotDuplicated(confLambda);
        this._insertStatementConfig = this.createStatementConfig(confLambda);
    }

    protected void assertStatementConfigNotDuplicated(StatementConfigCall<StatementConfig> configCall) {
        if (this._insertStatementConfig != null) {
            String msg = "Already registered the configuration: existing=" + this._insertStatementConfig + ", new=" + configCall;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected StatementConfig createStatementConfig(StatementConfigCall<StatementConfig> configCall) {
        if (configCall == null) {
            throw new IllegalArgumentException("The argument 'confLambda' should not be null.");
        }
        StatementConfig config = this.newStatementConfig();
        configCall.callback(config);
        return config;
    }

    protected StatementConfig newStatementConfig() {
        return new StatementConfig();
    }

    public StatementConfig getInsertStatementConfig() {
        return this._insertStatementConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._disableCommonColumnAutoSetup) {
            sb.append("CommonColumnDisabled");
        }
        if (this._disablePrimaryKeyIdentity) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("PKIdentityDisabled");
        }
        if (sb.length() == 0) {
            sb.append("default");
        }
        return DfTypeUtil.toClassTitle(this) + ":{" + sb.toString() + "}";
    }
}

