/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.logging.invoke;

import java.util.List;
import org.dbflute.bhv.logging.invoke.ByPassInvokeNameResult;
import org.dbflute.bhv.logging.invoke.InvokeNameExtractingCoinLogic;
import org.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.dbflute.helper.stacktrace.InvokeNameResult;

public class ByPassInvokeNameExtractor {
    protected final List<String> _suffixList;
    protected final int _startIndex;
    protected final int _loopSize;
    protected final InvokeNameExtractingCoinLogic _coinLogic = this.createInvokeNameExtractingCoinLogic();

    protected InvokeNameExtractingCoinLogic createInvokeNameExtractingCoinLogic() {
        return new InvokeNameExtractingCoinLogic();
    }

    public ByPassInvokeNameExtractor(List<String> suffixList, int startIndex, int loopSize) {
        this._suffixList = suffixList;
        this._startIndex = startIndex;
        this._loopSize = loopSize;
    }

    public ByPassInvokeNameResult extractByPassInvoke(StackTraceElement[] stackTrace) {
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            @Override
            public boolean isTargetElement(String className, String methodName) {
                return ByPassInvokeNameExtractor.this.isClassNameEndsWith(className, ByPassInvokeNameExtractor.this._suffixList);
            }

            @Override
            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            @Override
            public boolean isUseAdditionalInfo() {
                return true;
            }

            @Override
            public int getStartIndex() {
                return ByPassInvokeNameExtractor.this._startIndex;
            }

            @Override
            public int getLoopSize() {
                return ByPassInvokeNameExtractor.this._loopSize >= 0 ? ByPassInvokeNameExtractor.this._loopSize : ByPassInvokeNameExtractor.this.getInvocationExtractingMaxLoopSize();
            }
        };
        List<InvokeNameResult> invokeNameResultList = this.extractInvokeName(resource, stackTrace);
        return new ByPassInvokeNameResult(invokeNameResultList);
    }

    protected int getInvocationExtractingMaxLoopSize() {
        return 15;
    }

    protected List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource, StackTraceElement[] stackTrace) {
        return this._coinLogic.extractInvokeName(resource, stackTrace);
    }

    protected boolean isClassNameEndsWith(String className, List<String> suffixList) {
        return this._coinLogic.isClassNameEndsWith(className, suffixList);
    }

    protected boolean isClassNameContains(String className, List<String> keywordList) {
        return this._coinLogic.isClassNameContains(className, keywordList);
    }
}

