/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.core.command;

import org.dbflute.Entity;
import org.dbflute.bhv.core.SqlExecutionCreator;
import org.dbflute.bhv.core.command.AbstractSelectCBCommand;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.bhv.core.context.FetchAssistContext;
import org.dbflute.bhv.readable.EntityRowHandler;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.util.DfTypeUtil;

public class SelectCursorCBCommand<ENTITY extends Entity>
extends AbstractSelectCBCommand<ENTITY> {
    protected Class<? extends ENTITY> _entityType;
    protected EntityRowHandler<ENTITY> _entityRowHandler;

    @Override
    public String getCommandName() {
        return "selectCursor";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return Object.class;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public boolean isSelectCursor() {
        return true;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        ConditionBean cb = this._conditionBean;
        FetchAssistContext.setFetchBeanOnThread(cb);
        ConditionBeanContext.setConditionBeanOnThread(cb);
        ConditionBeanContext.setEntityRowHandlerOnThread(this._entityRowHandler);
    }

    @Override
    public void afterExecuting() {
        this.assertStatus("afterExecuting");
    }

    @Override
    public String buildSqlExecutionKey() {
        String handlerName = this._entityRowHandler.getClass().getName();
        String entityName = DfTypeUtil.toClassTitle(this._entityType);
        return super.buildSqlExecutionKey() + ":" + handlerName + ":" + entityName;
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return () -> {
            TnBeanMetaData bmd = this.createBeanMetaData();
            TnResultSetHandler handler = this.createBeanCursorResultSetHandler(bmd);
            return this.createSelectCBExecution(this._conditionBean.getClass(), handler);
        };
    }

    protected TnBeanMetaData createBeanMetaData() {
        return this._beanMetaDataFactory.createBeanMetaData(this._entityType);
    }

    @Override
    protected void assertStatus(String methodName) {
        super.assertStatus(methodName);
        if (this._entityType == null) {
            throw new IllegalStateException(this.buildAssertMessage("_entityType", methodName));
        }
        if (this._entityRowHandler == null) {
            throw new IllegalStateException(this.buildAssertMessage("_cursorHandler", methodName));
        }
    }

    public void setEntityType(Class<? extends ENTITY> entityType) {
        this._entityType = entityType;
    }

    public void setEntityRowHandler(EntityRowHandler<ENTITY> entityRowHandler) {
        this._entityRowHandler = entityRowHandler;
    }
}

