/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.transform.filter;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.function.Function;

public class FilterWritablesBySchemaFunction
implements Function<Writable, Boolean> {
    private final ColumnMetaData meta;
    private final boolean keepValid;
    private final boolean excludeMissing;

    public FilterWritablesBySchemaFunction(ColumnMetaData meta, boolean keepValid) {
        this(meta, keepValid, false);
    }

    public FilterWritablesBySchemaFunction(ColumnMetaData meta, boolean keepValid, boolean excludeMissing) {
        this.meta = meta;
        this.keepValid = keepValid;
        this.excludeMissing = excludeMissing;
    }

    public Boolean apply(Writable v1) {
        boolean valid = this.meta.isValid(v1);
        if (this.excludeMissing && (v1 instanceof NullWritable || v1 instanceof Text && (v1.toString() == null || v1.toString().isEmpty()))) {
            return false;
        }
        if (this.keepValid) {
            return valid;
        }
        return !valid;
    }
}

