/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.misc;

import java.util.List;
import org.datavec.api.writable.Writable;
import org.datavec.local.transforms.misc.WritablesToStringFunction;
import org.nd4j.linalg.function.Function;

public class SequenceWritablesToStringFunction
implements Function<List<List<Writable>>, String> {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_TIME_STEP_DELIMITER = "\n";
    private final String delimiter;
    private final String timeStepDelimiter;
    private final String quote;

    public SequenceWritablesToStringFunction() {
        this(DEFAULT_DELIMITER);
    }

    public SequenceWritablesToStringFunction(String delim) {
        this(delim, DEFAULT_TIME_STEP_DELIMITER, null);
    }

    public SequenceWritablesToStringFunction(String delim, String timeStepDelimiter) {
        this(delim, timeStepDelimiter, null);
    }

    public String apply(List<List<Writable>> c) {
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        for (List<Writable> timeStep : c) {
            if (!firstLine) {
                sb.append(this.timeStepDelimiter);
            }
            WritablesToStringFunction.append(timeStep, sb, this.delimiter, this.quote);
            firstLine = false;
        }
        return sb.toString();
    }

    public SequenceWritablesToStringFunction(String delimiter, String timeStepDelimiter, String quote) {
        this.delimiter = delimiter;
        this.timeStepDelimiter = timeStepDelimiter;
        this.quote = quote;
    }
}

