/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.misc;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.function.Function;

public class NDArrayToWritablesFunction
implements Function<INDArray, List<Writable>> {
    private boolean useNdarrayWritable = false;

    public NDArrayToWritablesFunction() {
        this.useNdarrayWritable = false;
    }

    public List<Writable> apply(INDArray arr) {
        if (arr.rows() != 1) {
            throw new UnsupportedOperationException("Only NDArray row vectors can be converted to list of Writables (found " + arr.rows() + " rows)");
        }
        ArrayList<Writable> record = new ArrayList<Writable>();
        if (this.useNdarrayWritable) {
            record.add((Writable)new NDArrayWritable(arr));
        } else {
            for (int i = 0; i < arr.columns(); ++i) {
                record.add((Writable)new DoubleWritable(arr.getDouble(i)));
            }
        }
        return record;
    }

    public NDArrayToWritablesFunction(boolean useNdarrayWritable) {
        this.useNdarrayWritable = useNdarrayWritable;
    }
}

