/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.analysis.histogram;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.histogram.CategoricalHistogramCounter;
import org.datavec.api.transform.analysis.histogram.DoubleHistogramCounter;
import org.datavec.api.transform.analysis.histogram.HistogramCounter;
import org.datavec.api.transform.analysis.histogram.NDArrayHistogramCounter;
import org.datavec.api.transform.analysis.histogram.StringHistogramCounter;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.BiFunction;

public class HistogramAddFunction
implements BiFunction<List<HistogramCounter>, List<Writable>, List<HistogramCounter>> {
    private final int nBins;
    private final Schema schema;
    private final double[][] minsMaxes;

    public List<HistogramCounter> apply(List<HistogramCounter> histogramCounters, List<Writable> writables) {
        int size;
        int i;
        if (histogramCounters == null) {
            histogramCounters = new ArrayList<HistogramCounter>();
            List columnTypes = this.schema.getColumnTypes();
            i = 0;
            for (ColumnType ct : columnTypes) {
                switch (ct) {
                    case String: {
                        histogramCounters.add((HistogramCounter)new StringHistogramCounter((int)this.minsMaxes[i][0], (int)this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Integer: {
                        histogramCounters.add((HistogramCounter)new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Long: {
                        histogramCounters.add((HistogramCounter)new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Double: {
                        histogramCounters.add((HistogramCounter)new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Categorical: {
                        CategoricalMetaData meta = (CategoricalMetaData)this.schema.getMetaData(i);
                        histogramCounters.add((HistogramCounter)new CategoricalHistogramCounter(meta.getStateNames()));
                        break;
                    }
                    case Time: {
                        histogramCounters.add((HistogramCounter)new DoubleHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    case Bytes: {
                        histogramCounters.add(null);
                        break;
                    }
                    case NDArray: {
                        histogramCounters.add((HistogramCounter)new NDArrayHistogramCounter(this.minsMaxes[i][0], this.minsMaxes[i][1], this.nBins));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type: " + ct);
                    }
                }
                ++i;
            }
        }
        if ((size = histogramCounters.size()) != writables.size()) {
            throw new IllegalStateException("Writables list and number of counters does not match (" + writables.size() + " vs " + size + ")");
        }
        for (i = 0; i < size; ++i) {
            HistogramCounter hc = histogramCounters.get(i);
            if (hc == null) continue;
            hc.add(writables.get(i));
        }
        return histogramCounters;
    }

    public HistogramAddFunction(int nBins, Schema schema, double[][] minsMaxes) {
        this.nBins = nBins;
        this.schema = schema;
        this.minsMaxes = minsMaxes;
    }
}

