/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.datavec.common.data.NDArrayWritable;
import org.datavec.dataframe.api.BooleanColumn;
import org.datavec.dataframe.api.CategoryColumn;
import org.datavec.dataframe.api.DateColumn;
import org.datavec.dataframe.api.FloatColumn;
import org.datavec.dataframe.api.IntColumn;
import org.datavec.dataframe.api.LongColumn;
import org.datavec.dataframe.api.Table;
import org.datavec.dataframe.columns.Column;
import org.datavec.dataframe.store.ColumnMetadata;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class TableRecords {
    public static INDArray arrayFromTable(Table table) {
        INDArray arr = Nd4j.create((int)table.rowCount(), (int)table.columnCount());
        for (int i = 0; i < table.rowCount(); ++i) {
            for (int j = 0; j < table.columnCount(); ++j) {
                arr.putScalar(i, j, Double.valueOf(table.get(j, i)).doubleValue());
            }
        }
        return arr;
    }

    public static List<List<Writable>> fromTable(Table table) {
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        for (int i = 0; i < table.rowCount(); ++i) {
            ret.add(new ArrayList());
            for (int j = 0; j < table.columnCount(); ++j) {
                ((List)ret.get(i)).add(new DoubleWritable(Double.valueOf(table.get(j, i)).doubleValue()));
            }
        }
        return ret;
    }

    public static Table fromRecordsAndSchema(List<List<Writable>> writable, Schema schema) {
        Table table = Table.create((String)"table", (Column[])TableRecords.columnsForSchema(schema));
        for (int i = 0; i < writable.size(); ++i) {
            List<Writable> row = writable.get(i);
            if (row.size() == 1 && row.get(0) instanceof NDArrayWritable) {
                NDArrayWritable ndArrayWritable = (NDArrayWritable)row.get(0);
                INDArray arr = ndArrayWritable.get();
                if (arr.columns() != schema.numColumns()) {
                    throw new IllegalArgumentException("Found ndarray writable of illegal size " + arr.columns());
                }
                for (int j = 0; j < arr.length(); ++j) {
                    table.floatColumn(j).add(arr.getDouble(j));
                }
                continue;
            }
            if (row.size() == schema.numColumns()) {
                for (int j = 0; j < row.size(); ++j) {
                    table.floatColumn(j).add(row.get(j).toDouble());
                }
                continue;
            }
            throw new IllegalArgumentException("Illegal writable list of size " + row.size() + " at index " + i);
        }
        return table;
    }

    public static Column[] columnsForSchema(Schema schema) {
        Column[] ret = new Column[schema.numColumns()];
        block9: for (int i = 0; i < schema.numColumns(); ++i) {
            switch (schema.getType(i)) {
                case Double: {
                    ret[i] = new FloatColumn(schema.getName(i));
                    continue block9;
                }
                case Float: {
                    ret[i] = new FloatColumn(schema.getName(i));
                    continue block9;
                }
                case Long: {
                    ret[i] = new LongColumn(schema.getName(i));
                    continue block9;
                }
                case Integer: {
                    ret[i] = new IntColumn(schema.getName(i));
                    continue block9;
                }
                case Categorical: {
                    ret[i] = new CategoryColumn(schema.getName(i), 4);
                    continue block9;
                }
                case Time: {
                    ret[i] = new DateColumn(new ColumnMetadata((Column)new LongColumn(schema.getName(i))));
                    continue block9;
                }
                case Boolean: {
                    ret[i] = new BooleanColumn(new ColumnMetadata((Column)new IntColumn(schema.getName(i))));
                }
            }
        }
        return ret;
    }
}

