/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"borderValue"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BoxImageTransform
extends BaseImageTransform<Mat> {
    private int width;
    private int height;
    private int x;
    private int y;
    Scalar borderValue = Scalar.ZERO;

    public BoxImageTransform(@JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        this(null, width, height);
    }

    public BoxImageTransform(Random random, int width, int height) {
        super(random);
        this.width = width;
        this.height = height;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        Mat mat = (Mat)this.converter.convert(image.getFrame());
        Mat box = new Mat(this.height, this.width, mat.type());
        box.put(this.borderValue);
        this.x = (mat.cols() - this.width) / 2;
        this.y = (mat.rows() - this.height) / 2;
        int w = Math.min(mat.cols(), this.width);
        int h = Math.min(mat.rows(), this.height);
        Rect matRect = new Rect(this.x, this.y, w, h);
        Rect boxRect = new Rect(this.x, this.y, w, h);
        if (this.x <= 0) {
            matRect.x(0);
            boxRect.x(-this.x);
        } else {
            matRect.x(this.x);
            boxRect.x(0);
        }
        if (this.y <= 0) {
            matRect.y(0);
            boxRect.y(-this.y);
        } else {
            matRect.y(this.y);
            boxRect.y(0);
        }
        mat.apply(matRect).copyTo(box.apply(boxRect));
        return new ImageWritable(this.converter.convert((Object)box));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public BoxImageTransform width(int width) {
        this.width = width;
        return this;
    }

    public BoxImageTransform height(int height) {
        this.height = height;
        return this;
    }

    public BoxImageTransform x(int x) {
        this.x = x;
        return this;
    }

    public BoxImageTransform y(int y) {
        this.y = y;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoxImageTransform)) {
            return false;
        }
        BoxImageTransform other = (BoxImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.width() != other.width()) {
            return false;
        }
        if (this.height() != other.height()) {
            return false;
        }
        if (this.x() != other.x()) {
            return false;
        }
        if (this.y() != other.y()) {
            return false;
        }
        Scalar this$borderValue = this.borderValue();
        Scalar other$borderValue = other.borderValue();
        return !(this$borderValue == null ? other$borderValue != null : !this$borderValue.equals(other$borderValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BoxImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.width();
        result = result * 59 + this.height();
        result = result * 59 + this.x();
        result = result * 59 + this.y();
        Scalar $borderValue = this.borderValue();
        result = result * 59 + ($borderValue == null ? 43 : $borderValue.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BoxImageTransform(width=" + this.width() + ", height=" + this.height() + ", x=" + this.x() + ", y=" + this.y() + ", borderValue=" + this.borderValue() + ")";
    }

    public Scalar borderValue() {
        return this.borderValue;
    }

    public BoxImageTransform borderValue(Scalar borderValue) {
        this.borderValue = borderValue;
        return this;
    }
}

