/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.nio.FloatBuffer;
import java.util.Random;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"interMode", "borderMode", "borderValue", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RotateImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private float centerx;
    private float centery;
    private float angle;
    private float scale;
    private int interMode = 1;
    private int borderMode = 0;
    private opencv_core.Scalar borderValue = opencv_core.Scalar.ZERO;
    private opencv_core.Mat M;

    public RotateImageTransform(float angle) {
        this(null, 0.0f, 0.0f, angle, 0.0f);
    }

    public RotateImageTransform(Random random, float angle) {
        this(random, 0.0f, 0.0f, angle, 0.0f);
    }

    public RotateImageTransform(@JsonProperty(value="centerx") float centerx, @JsonProperty(value="centery") float centery, @JsonProperty(value="angle") float angle, @JsonProperty(value="scale") float scale) {
        this(null, centerx, centery, angle, scale);
    }

    public RotateImageTransform(Random random, float centerx, float centery, float angle, float scale) {
        super(random);
        this.centerx = centerx;
        this.centery = centery;
        this.angle = angle;
        this.scale = scale;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        float cy = (float)(mat.rows() / 2) + this.centery * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        float cx = (float)(mat.cols() / 2) + this.centerx * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        float a = this.angle * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        float s = 1.0f + this.scale * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f);
        opencv_core.Mat result = new opencv_core.Mat();
        this.M = opencv_imgproc.getRotationMatrix2D((opencv_core.Point2f)new opencv_core.Point2f(cx, cy), (double)a, (double)s);
        opencv_imgproc.warpAffine((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Mat)this.M, (opencv_core.Size)mat.size(), (int)this.interMode, (int)this.borderMode, (opencv_core.Scalar)this.borderValue);
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        opencv_core.Mat src = new opencv_core.Mat(1, coordinates.length / 2, opencv_core.CV_32FC2, (Pointer)new FloatPointer(coordinates));
        opencv_core.Mat dst = new opencv_core.Mat();
        opencv_core.transform((opencv_core.Mat)src, (opencv_core.Mat)dst, (opencv_core.Mat)this.M);
        FloatBuffer buf = (FloatBuffer)dst.createBuffer();
        float[] transformed = new float[coordinates.length];
        buf.get(transformed);
        return transformed;
    }

    public float centerx() {
        return this.centerx;
    }

    public float centery() {
        return this.centery;
    }

    public float angle() {
        return this.angle;
    }

    public float scale() {
        return this.scale;
    }

    public opencv_core.Mat M() {
        return this.M;
    }

    public RotateImageTransform centerx(float centerx) {
        this.centerx = centerx;
        return this;
    }

    public RotateImageTransform centery(float centery) {
        this.centery = centery;
        return this;
    }

    public RotateImageTransform angle(float angle) {
        this.angle = angle;
        return this;
    }

    public RotateImageTransform scale(float scale) {
        this.scale = scale;
        return this;
    }

    public RotateImageTransform M(opencv_core.Mat M) {
        this.M = M;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RotateImageTransform)) {
            return false;
        }
        RotateImageTransform other = (RotateImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.centerx(), other.centerx()) != 0) {
            return false;
        }
        if (Float.compare(this.centery(), other.centery()) != 0) {
            return false;
        }
        if (Float.compare(this.angle(), other.angle()) != 0) {
            return false;
        }
        if (Float.compare(this.scale(), other.scale()) != 0) {
            return false;
        }
        if (this.interMode() != other.interMode()) {
            return false;
        }
        if (this.borderMode() != other.borderMode()) {
            return false;
        }
        opencv_core.Scalar this$borderValue = this.borderValue();
        opencv_core.Scalar other$borderValue = other.borderValue();
        if (this$borderValue == null ? other$borderValue != null : !this$borderValue.equals(other$borderValue)) {
            return false;
        }
        opencv_core.Mat this$M = this.M();
        opencv_core.Mat other$M = other.M();
        return !(this$M == null ? other$M != null : !this$M.equals(other$M));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RotateImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.centerx());
        result = result * 59 + Float.floatToIntBits(this.centery());
        result = result * 59 + Float.floatToIntBits(this.angle());
        result = result * 59 + Float.floatToIntBits(this.scale());
        result = result * 59 + this.interMode();
        result = result * 59 + this.borderMode();
        opencv_core.Scalar $borderValue = this.borderValue();
        result = result * 59 + ($borderValue == null ? 43 : $borderValue.hashCode());
        opencv_core.Mat $M = this.M();
        result = result * 59 + ($M == null ? 43 : $M.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RotateImageTransform(centerx=" + this.centerx() + ", centery=" + this.centery() + ", angle=" + this.angle() + ", scale=" + this.scale() + ", interMode=" + this.interMode() + ", borderMode=" + this.borderMode() + ", borderValue=" + this.borderValue() + ", M=" + this.M() + ")";
    }

    public int interMode() {
        return this.interMode;
    }

    public RotateImageTransform interMode(int interMode) {
        this.interMode = interMode;
        return this;
    }

    public int borderMode() {
        return this.borderMode;
    }

    public RotateImageTransform borderMode(int borderMode) {
        this.borderMode = borderMode;
        return this;
    }

    public opencv_core.Scalar borderValue() {
        return this.borderValue;
    }

    public RotateImageTransform borderValue(opencv_core.Scalar borderValue) {
        this.borderValue = borderValue;
        return this;
    }
}

