/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CropImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private int cropTop;
    private int cropLeft;
    private int cropBottom;
    private int cropRight;
    private int x;
    private int y;

    public CropImageTransform(int crop) {
        this(null, crop, crop, crop, crop);
    }

    public CropImageTransform(Random random, int crop) {
        this(random, crop, crop, crop, crop);
    }

    public CropImageTransform(@JsonProperty(value="cropTop") int cropTop, @JsonProperty(value="cropLeft") int cropLeft, @JsonProperty(value="cropBottom") int cropBottom, @JsonProperty(value="cropRight") int cropRight) {
        this(null, cropTop, cropLeft, cropBottom, cropRight);
    }

    public CropImageTransform(Random random, int cropTop, int cropLeft, int cropBottom, int cropRight) {
        super(random);
        this.cropTop = cropTop;
        this.cropLeft = cropLeft;
        this.cropBottom = cropBottom;
        this.cropRight = cropRight;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        int top = random != null ? random.nextInt(this.cropTop + 1) : this.cropTop;
        int left = random != null ? random.nextInt(this.cropLeft + 1) : this.cropLeft;
        int bottom = random != null ? random.nextInt(this.cropBottom + 1) : this.cropBottom;
        int right = random != null ? random.nextInt(this.cropRight + 1) : this.cropRight;
        this.y = Math.min(top, mat.rows() - 1);
        this.x = Math.min(left, mat.cols() - 1);
        int h = Math.max(1, mat.rows() - bottom - this.y);
        int w = Math.max(1, mat.cols() - right - this.x);
        opencv_core.Mat result = mat.apply(new opencv_core.Rect(this.x, this.y, w, h));
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }
}

