/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.recordreader.objdetect;

public class ImageObject {
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private final String label;

    public ImageObject(int x1, int y1, int x2, int y2, String label) {
        if (x1 > x2 || y1 > y2) {
            throw new IllegalArgumentException("Invalid input: (x1,y1), top left position must have values less than (x2,y2) bottom right position. Got: (" + x1 + "," + y1 + "), (" + x2 + "," + y2 + ")");
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.label = label;
    }

    public double getXCenterPixels() {
        return (double)(this.x1 + this.x2) / 2.0;
    }

    public double getYCenterPixels() {
        return (double)(this.y1 + this.y2) / 2.0;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageObject)) {
            return false;
        }
        ImageObject other = (ImageObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX1() != other.getX1()) {
            return false;
        }
        if (this.getY1() != other.getY1()) {
            return false;
        }
        if (this.getX2() != other.getX2()) {
            return false;
        }
        if (this.getY2() != other.getY2()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX1();
        result = result * 59 + this.getY1();
        result = result * 59 + this.getX2();
        result = result * 59 + this.getY2();
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "ImageObject(x1=" + this.getX1() + ", y1=" + this.getY1() + ", x2=" + this.getX2() + ", y2=" + this.getY2() + ", label=" + this.getLabel() + ")";
    }
}

