/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResizeImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private int newHeight;
    private int newWidth;

    public ResizeImageTransform(@JsonProperty(value="newWidth") int newWidth, @JsonProperty(value="newHeight") int newHeight) {
        this(null, newWidth, newHeight);
    }

    public ResizeImageTransform(Random random, int newWidth, int newHeight) {
        super(random);
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat result = new opencv_core.Mat();
        opencv_imgproc.resize((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Size)new opencv_core.Size(this.newWidth, this.newHeight));
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

