/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.FFmpegFrameFilter;
import org.bytedeco.javacv.FrameFilter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;

public class FilterImageTransform
extends BaseImageTransform {
    FFmpegFrameFilter filter;

    public FilterImageTransform(String filters, int width, int height) {
        this(filters, width, height, 3);
    }

    public FilterImageTransform(String filters, int width, int height, int channels) {
        super(null);
        int pixelFormat;
        int n = channels == 1 ? 8 : (channels == 3 ? 3 : (pixelFormat = channels == 4 ? 28 : -1));
        if (pixelFormat == -1) {
            throw new IllegalArgumentException("Unsupported number of channels: " + channels);
        }
        try {
            this.filter = new FFmpegFrameFilter(filters, width, height);
            this.filter.setPixelFormat(pixelFormat);
            this.filter.start();
        }
        catch (FrameFilter.Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        try {
            this.filter.push(image.getFrame());
            image = new ImageWritable(this.filter.pull());
        }
        catch (FrameFilter.Exception e) {
            throw new RuntimeException(e);
        }
        return image;
    }
}

