/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;

public class CropImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    int cropTop;
    int cropLeft;
    int cropBottom;
    int cropRight;

    public CropImageTransform(int crop) {
        this(null, crop, crop, crop, crop);
    }

    public CropImageTransform(Random random, int crop) {
        this(random, crop, crop, crop, crop);
    }

    public CropImageTransform(int cropTop, int cropLeft, int cropBottom, int cropRight) {
        this(null, cropTop, cropLeft, cropBottom, cropRight);
    }

    public CropImageTransform(Random random, int cropTop, int cropLeft, int cropBottom, int cropRight) {
        super(random);
        this.cropTop = cropTop;
        this.cropLeft = cropLeft;
        this.cropBottom = cropBottom;
        this.cropRight = cropRight;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        int top = random != null ? random.nextInt(this.cropTop + 1) : this.cropTop;
        int left = random != null ? random.nextInt(this.cropLeft + 1) : this.cropLeft;
        int bottom = random != null ? random.nextInt(this.cropBottom + 1) : this.cropBottom;
        int right = random != null ? random.nextInt(this.cropRight + 1) : this.cropRight;
        int y = Math.min(top, mat.rows() - 1);
        int x = Math.min(left, mat.cols() - 1);
        int h = Math.max(1, mat.rows() - bottom - y);
        int w = Math.max(1, mat.cols() - right - x);
        opencv_core.Mat result = mat.apply(new opencv_core.Rect(x, y, w, h));
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

