/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.window;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "offsetAmountMilliseconds", "windowSizeMilliseconds", "windowSeparationMilliseconds", "timeZone"})
public class OverlappingTimeWindowFunction
implements WindowFunction {
    private final String timeColumn;
    private final long windowSize;
    private final TimeUnit windowSizeUnit;
    private final long windowSeparation;
    private final TimeUnit windowSeparationUnit;
    private final long offsetAmount;
    private final TimeUnit offsetUnit;
    private final boolean addWindowStartTimeColumn;
    private final boolean addWindowEndTimeColumn;
    private final boolean excludeEmptyWindows;
    private Schema inputSchema;
    private final long offsetAmountMilliseconds;
    private final long windowSizeMilliseconds;
    private final long windowSeparationMilliseconds;
    private DateTimeZone timeZone;

    public OverlappingTimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit, long windowSeparation, TimeUnit windowSeparationUnit) {
        this(timeColumn, windowSize, windowSizeUnit, windowSeparation, windowSeparationUnit, 0L, null);
    }

    public OverlappingTimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit, long windowSeparation, TimeUnit windowSeparationUnit, boolean addWindowStartTimeColumn, boolean addWindowEndTimeColumn) {
        this(timeColumn, windowSize, windowSizeUnit, windowSeparation, windowSeparationUnit, 0L, null, addWindowStartTimeColumn, addWindowEndTimeColumn, false);
    }

    public OverlappingTimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit, long windowSeparation, TimeUnit windowSeparationUnit, long offset, TimeUnit offsetUnit) {
        this(timeColumn, windowSize, windowSizeUnit, windowSeparation, windowSeparationUnit, offset, offsetUnit, false, false, false);
    }

    public OverlappingTimeWindowFunction(@JsonProperty(value="timeColumn") String timeColumn, @JsonProperty(value="windowSize") long windowSize, @JsonProperty(value="windowSizeUnit") TimeUnit windowSizeUnit, @JsonProperty(value="windowSeparation") long windowSeparation, @JsonProperty(value="windowSeparationUnit") TimeUnit windowSeparationUnit, @JsonProperty(value="offset") long offset, @JsonProperty(value="offsetUnit") TimeUnit offsetUnit, @JsonProperty(value="addWindowStartTimeColumn") boolean addWindowStartTimeColumn, @JsonProperty(value="addWindowEndTimeColumn") boolean addWindowEndTimeColumn, @JsonProperty(value="excludeEmptyWindows") boolean excludeEmptyWindows) {
        this.timeColumn = timeColumn;
        this.windowSize = windowSize;
        this.windowSizeUnit = windowSizeUnit;
        this.windowSeparation = windowSeparation;
        this.windowSeparationUnit = windowSeparationUnit;
        this.offsetAmount = offset;
        this.offsetUnit = offsetUnit;
        this.addWindowStartTimeColumn = addWindowStartTimeColumn;
        this.addWindowEndTimeColumn = addWindowEndTimeColumn;
        this.excludeEmptyWindows = excludeEmptyWindows;
        this.offsetAmountMilliseconds = this.offsetAmount == 0L || offsetUnit == null ? 0L : TimeUnit.MILLISECONDS.convert(offset, offsetUnit);
        this.windowSizeMilliseconds = TimeUnit.MILLISECONDS.convert(windowSize, windowSizeUnit);
        this.windowSeparationMilliseconds = TimeUnit.MILLISECONDS.convert(windowSeparation, windowSeparationUnit);
    }

    private OverlappingTimeWindowFunction(Builder builder) {
        this(builder.timeColumn, builder.windowSize, builder.windowSizeUnit, builder.windowSeparation, builder.windowSeparationUnit, builder.offsetAmount, builder.offsetUnit, builder.addWindowStartTimeColumn, builder.addWindowEndTimeColumn, builder.excludeEmptyWindows);
    }

    @Override
    public void setInputSchema(Schema schema) {
        if (!(schema instanceof SequenceSchema)) {
            throw new IllegalArgumentException("Invalid schema: OverlappingTimeWindowFunction can only operate on SequenceSchema");
        }
        if (!schema.hasColumn(this.timeColumn)) {
            throw new IllegalStateException("Input schema does not have a column with name \"" + this.timeColumn + "\"");
        }
        if (schema.getMetaData(this.timeColumn).getColumnType() != ColumnType.Time) {
            throw new IllegalStateException("Invalid column: column \"" + this.timeColumn + "\" is not of type " + (Object)((Object)ColumnType.Time) + "; is " + (Object)((Object)schema.getMetaData(this.timeColumn).getColumnType()));
        }
        this.inputSchema = schema;
        this.timeZone = ((TimeMetaData)schema.getMetaData(this.timeColumn)).getTimeZone();
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (!this.addWindowStartTimeColumn && !this.addWindowEndTimeColumn) {
            return inputSchema;
        }
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>();
        newMeta.addAll(inputSchema.getColumnMetaData());
        if (this.addWindowStartTimeColumn) {
            newMeta.add(new TimeMetaData("windowStartTime"));
        }
        if (this.addWindowEndTimeColumn) {
            newMeta.add(new TimeMetaData("windowEndTime"));
        }
        return inputSchema.newSchema(newMeta);
    }

    public String toString() {
        return "OverlappingTimeWindowFunction(columnName=\"" + this.timeColumn + "\",windowSize=" + this.windowSize + (Object)((Object)this.windowSizeUnit) + ",windowSeparation=" + this.windowSeparation + (Object)((Object)this.windowSeparationUnit) + ",offset=" + this.offsetAmount + (this.offsetAmount != 0L && this.offsetUnit != null ? this.offsetUnit : "") + (this.addWindowStartTimeColumn ? ",addWindowStartTimeColumn=true" : "") + (this.addWindowEndTimeColumn ? ",addWindowEndTimeColumn=true" : "") + (this.excludeEmptyWindows ? ",excludeEmptyWindows=true" : "") + ")";
    }

    @Override
    public List<List<List<Writable>>> applyToSequence(List<List<Writable>> sequence) {
        long windowBorderLastTimeStep;
        int timeColumnIdx = this.inputSchema.getIndexOfColumn(this.timeColumn);
        ArrayList<List<List<Writable>>> out = new ArrayList<List<List<Writable>>>();
        long firstTimeStepTimePlusOffset = sequence.get(0).get(timeColumnIdx).toLong() + this.offsetAmountMilliseconds;
        long windowBorder = firstTimeStepTimePlusOffset - firstTimeStepTimePlusOffset % this.windowSeparationMilliseconds;
        long lastTimeStepTimePlusOffset = sequence.get(sequence.size() - 1).get(timeColumnIdx).toLong() + this.offsetAmountMilliseconds;
        long lastWindowStartTime = windowBorderLastTimeStep = lastTimeStepTimePlusOffset - lastTimeStepTimePlusOffset % this.windowSeparationMilliseconds;
        long currentWindowStartTime = windowBorder + this.windowSeparationMilliseconds - this.windowSizeMilliseconds;
        long nextWindowStartTime = currentWindowStartTime + this.windowSeparationMilliseconds;
        long currentWindowEndTime = currentWindowStartTime + this.windowSizeMilliseconds;
        ArrayList<List<Writable>> currentWindow = new ArrayList<List<Writable>>();
        int currentWindowStartIdx = 0;
        int sequenceLength = sequence.size();
        boolean foundIndexForNextWindowStart = false;
        block0: while (currentWindowStartTime <= lastWindowStartTime) {
            for (int i = currentWindowStartIdx; i < sequenceLength; ++i) {
                List<Writable> timeStep = sequence.get(i);
                long currentTime = timeStep.get(timeColumnIdx).toLong();
                if (!foundIndexForNextWindowStart && currentTime >= nextWindowStartTime) {
                    foundIndexForNextWindowStart = true;
                    currentWindowStartIdx = i;
                }
                boolean nextWindow = false;
                if (currentTime < currentWindowEndTime) {
                    if (this.addWindowStartTimeColumn || this.addWindowEndTimeColumn) {
                        ArrayList<Writable> timeStep2 = new ArrayList<Writable>(timeStep);
                        if (this.addWindowStartTimeColumn) {
                            timeStep2.add(new LongWritable(currentWindowStartTime));
                        }
                        if (this.addWindowEndTimeColumn) {
                            timeStep2.add(new LongWritable(currentWindowStartTime + this.windowSizeMilliseconds));
                        }
                        currentWindow.add(timeStep2);
                    } else {
                        currentWindow.add(timeStep);
                    }
                } else {
                    nextWindow = true;
                }
                if (i == sequenceLength - 1) {
                    nextWindow = true;
                }
                if (!nextWindow) continue;
                if (!this.excludeEmptyWindows || currentWindow.size() != 0) {
                    out.add(currentWindow);
                }
                currentWindow = new ArrayList();
                currentWindowEndTime = (currentWindowStartTime += this.windowSeparationMilliseconds) + this.windowSizeMilliseconds;
                foundIndexForNextWindowStart = false;
                nextWindowStartTime = currentWindowStartTime + this.windowSeparationMilliseconds;
                continue block0;
            }
        }
        return out;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverlappingTimeWindowFunction)) {
            return false;
        }
        OverlappingTimeWindowFunction other = (OverlappingTimeWindowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$timeColumn = this.getTimeColumn();
        String other$timeColumn = other.getTimeColumn();
        if (this$timeColumn == null ? other$timeColumn != null : !this$timeColumn.equals(other$timeColumn)) {
            return false;
        }
        if (this.getWindowSize() != other.getWindowSize()) {
            return false;
        }
        TimeUnit this$windowSizeUnit = this.getWindowSizeUnit();
        TimeUnit other$windowSizeUnit = other.getWindowSizeUnit();
        if (this$windowSizeUnit == null ? other$windowSizeUnit != null : !((Object)((Object)this$windowSizeUnit)).equals((Object)other$windowSizeUnit)) {
            return false;
        }
        if (this.getWindowSeparation() != other.getWindowSeparation()) {
            return false;
        }
        TimeUnit this$windowSeparationUnit = this.getWindowSeparationUnit();
        TimeUnit other$windowSeparationUnit = other.getWindowSeparationUnit();
        if (this$windowSeparationUnit == null ? other$windowSeparationUnit != null : !((Object)((Object)this$windowSeparationUnit)).equals((Object)other$windowSeparationUnit)) {
            return false;
        }
        if (this.getOffsetAmount() != other.getOffsetAmount()) {
            return false;
        }
        TimeUnit this$offsetUnit = this.getOffsetUnit();
        TimeUnit other$offsetUnit = other.getOffsetUnit();
        if (this$offsetUnit == null ? other$offsetUnit != null : !((Object)((Object)this$offsetUnit)).equals((Object)other$offsetUnit)) {
            return false;
        }
        if (this.isAddWindowStartTimeColumn() != other.isAddWindowStartTimeColumn()) {
            return false;
        }
        if (this.isAddWindowEndTimeColumn() != other.isAddWindowEndTimeColumn()) {
            return false;
        }
        return this.isExcludeEmptyWindows() == other.isExcludeEmptyWindows();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OverlappingTimeWindowFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $timeColumn = this.getTimeColumn();
        result = result * 59 + ($timeColumn == null ? 43 : $timeColumn.hashCode());
        long $windowSize = this.getWindowSize();
        result = result * 59 + (int)($windowSize >>> 32 ^ $windowSize);
        TimeUnit $windowSizeUnit = this.getWindowSizeUnit();
        result = result * 59 + ($windowSizeUnit == null ? 43 : ((Object)((Object)$windowSizeUnit)).hashCode());
        long $windowSeparation = this.getWindowSeparation();
        result = result * 59 + (int)($windowSeparation >>> 32 ^ $windowSeparation);
        TimeUnit $windowSeparationUnit = this.getWindowSeparationUnit();
        result = result * 59 + ($windowSeparationUnit == null ? 43 : ((Object)((Object)$windowSeparationUnit)).hashCode());
        long $offsetAmount = this.getOffsetAmount();
        result = result * 59 + (int)($offsetAmount >>> 32 ^ $offsetAmount);
        TimeUnit $offsetUnit = this.getOffsetUnit();
        result = result * 59 + ($offsetUnit == null ? 43 : ((Object)((Object)$offsetUnit)).hashCode());
        result = result * 59 + (this.isAddWindowStartTimeColumn() ? 79 : 97);
        result = result * 59 + (this.isAddWindowEndTimeColumn() ? 79 : 97);
        result = result * 59 + (this.isExcludeEmptyWindows() ? 79 : 97);
        return result;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public TimeUnit getWindowSizeUnit() {
        return this.windowSizeUnit;
    }

    public long getWindowSeparation() {
        return this.windowSeparation;
    }

    public TimeUnit getWindowSeparationUnit() {
        return this.windowSeparationUnit;
    }

    public long getOffsetAmount() {
        return this.offsetAmount;
    }

    public TimeUnit getOffsetUnit() {
        return this.offsetUnit;
    }

    public boolean isAddWindowStartTimeColumn() {
        return this.addWindowStartTimeColumn;
    }

    public boolean isAddWindowEndTimeColumn() {
        return this.addWindowEndTimeColumn;
    }

    public boolean isExcludeEmptyWindows() {
        return this.excludeEmptyWindows;
    }

    public long getOffsetAmountMilliseconds() {
        return this.offsetAmountMilliseconds;
    }

    public long getWindowSizeMilliseconds() {
        return this.windowSizeMilliseconds;
    }

    public long getWindowSeparationMilliseconds() {
        return this.windowSeparationMilliseconds;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public static class Builder {
        private String timeColumn;
        private long windowSize = -1L;
        private TimeUnit windowSizeUnit;
        private long windowSeparation = -1L;
        private TimeUnit windowSeparationUnit;
        private long offsetAmount;
        private TimeUnit offsetUnit;
        private boolean addWindowStartTimeColumn = false;
        private boolean addWindowEndTimeColumn = false;
        private boolean excludeEmptyWindows = false;

        public Builder timeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public Builder windowSize(long windowSize, TimeUnit windowSizeUnit) {
            this.windowSize = windowSize;
            this.windowSizeUnit = windowSizeUnit;
            return this;
        }

        public Builder windowSeparation(long windowSeparation, TimeUnit windowSeparationUnit) {
            this.windowSeparation = windowSeparation;
            this.windowSeparationUnit = windowSeparationUnit;
            return this;
        }

        public Builder offset(long offsetAmount, TimeUnit offsetUnit) {
            this.offsetAmount = offsetAmount;
            this.offsetUnit = offsetUnit;
            return this;
        }

        public Builder addWindowStartTimeColumn(boolean addWindowStartTimeColumn) {
            this.addWindowStartTimeColumn = addWindowStartTimeColumn;
            return this;
        }

        public Builder addWindowEndTimeColumn(boolean addWindowEndTimeColumn) {
            this.addWindowEndTimeColumn = addWindowEndTimeColumn;
            return this;
        }

        public Builder excludeEmptyWindows(boolean excludeEmptyWindows) {
            this.excludeEmptyWindows = excludeEmptyWindows;
            return this;
        }

        public OverlappingTimeWindowFunction build() {
            if (this.timeColumn == null) {
                throw new IllegalStateException("Time column is null (not specified)");
            }
            if (this.windowSize == -1L || this.windowSizeUnit == null) {
                throw new IllegalStateException("Window size/unit not set");
            }
            if (this.windowSeparation == -1L || this.windowSeparationUnit == null) {
                throw new IllegalStateException("Window separation and/or unit not set");
            }
            return new OverlappingTimeWindowFunction(this);
        }
    }
}

