/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import java.util.Arrays;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"allowVarLength"})
public class NDArrayMetaData
extends BaseColumnMetaData {
    private long[] shape;
    private boolean allowVarLength;

    public NDArrayMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="shape") long[] shape) {
        super(name);
        this.shape = shape;
        for (long i : shape) {
            if (i >= 0L) continue;
            this.allowVarLength = true;
            break;
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.NDArray;
    }

    @Override
    public boolean isValid(Writable writable) {
        if (!(writable instanceof NDArrayWritable)) {
            return false;
        }
        INDArray arr = ((NDArrayWritable)writable).get();
        if (arr == null) {
            return false;
        }
        if (this.allowVarLength) {
            for (int i = 0; i < this.shape.length; ++i) {
                if (this.shape[i] < 0L || this.shape[i] == arr.size(i)) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(this.shape, arr.shape());
    }

    @Override
    public boolean isValid(Object input) {
        if (input == null) {
            return false;
        }
        if (input instanceof Writable) {
            return this.isValid((Writable)input);
        }
        if (input instanceof INDArray) {
            return this.isValid(new NDArrayWritable((INDArray)input));
        }
        throw new UnsupportedOperationException("Unknown object type: " + input.getClass());
    }

    @Override
    public NDArrayMetaData clone() {
        return new NDArrayMetaData(this.name, (long[])this.shape.clone());
    }

    public long[] getShape() {
        return this.shape;
    }

    public boolean isAllowVarLength() {
        return this.allowVarLength;
    }

    public void setShape(long[] shape) {
        this.shape = shape;
    }

    public void setAllowVarLength(boolean allowVarLength) {
        this.allowVarLength = allowVarLength;
    }

    public String toString() {
        return "NDArrayMetaData(shape=" + Arrays.toString(this.getShape()) + ", allowVarLength=" + this.isAllowVarLength() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayMetaData)) {
            return false;
        }
        NDArrayMetaData other = (NDArrayMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        return this.isAllowVarLength() == other.isAllowVarLength();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NDArrayMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getShape());
        result = result * 59 + (this.isAllowVarLength() ? 79 : 97);
        return result;
    }
}

